/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.validator.BeanValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanValidatorUtil {
    private static final Log log = LogFactory.getLog(BeanValidatorUtil.class);
    private static ValueStack sharedValueStack;

    public static synchronized ValueStack getSharedValueStack() {
        if (sharedValueStack == null) {
            ConfigurationManager confManager = new ConfigurationManager();
            Configuration conf = confManager.getConfiguration();
            sharedValueStack = ((ValueStackFactory)conf.getContainer().getInstance(ValueStackFactory.class)).createValueStack();
            if (log.isDebugEnabled()) {
                log.debug((Object)("init shared value stack " + sharedValueStack));
            }
        }
        return sharedValueStack;
    }

    protected BeanValidatorUtil() {
    }

    public static void setValidatorBean(JAXXObject ui, Object bean, String ... excludeIds) {
        if (!JAXXValidator.class.isAssignableFrom(ui.getClass())) {
            return;
        }
        JAXXValidator jaxxValidator = (JAXXValidator)((Object)ui);
        List<String> validatorIds = jaxxValidator.getValidatorIds();
        if (excludeIds.length > 0) {
            validatorIds = new ArrayList<String>(validatorIds);
            for (String excludeId : excludeIds) {
                validatorIds.remove(excludeId);
            }
        }
        for (String validatorId : validatorIds) {
            BeanValidator<?> beanValidator = jaxxValidator.getValidator(validatorId);
            if (bean != null && !beanValidator.getBeanClass().isAssignableFrom(bean.getClass())) continue;
            beanValidator.setBean(bean);
        }
    }

    public static void setValidatorChanged(JAXXObject ui, boolean newValue, String ... excludeIds) {
        if (!JAXXValidator.class.isAssignableFrom(ui.getClass())) {
            return;
        }
        JAXXValidator jaxxValidator = (JAXXValidator)((Object)ui);
        List<String> validatorIds = jaxxValidator.getValidatorIds();
        if (excludeIds.length > 0) {
            validatorIds = new ArrayList<String>(validatorIds);
            for (String excludeId : excludeIds) {
                validatorIds.remove(excludeId);
            }
        }
        for (String validatorId : validatorIds) {
            BeanValidator<?> beanValidator = jaxxValidator.getValidator(validatorId);
            beanValidator.setChanged(newValue);
        }
    }

    public static void convert(BeanValidator<?> validator, String fieldName, String value, Class<?> valueClass) {
        Object result = validator.convert(fieldName, value, valueClass);
        if (result != null) {
            try {
                BeanInfo info = Introspector.getBeanInfo(validator.getBean().getClass());
                for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                    if (!fieldName.equals(descriptor.getName()) || descriptor.getWriteMethod() == null) continue;
                    descriptor.getWriteMethod().invoke(validator.getBean(), result);
                    break;
                }
            }
            catch (IntrospectionException e) {
                log.error((Object)("could not obtain beanInfo for " + valueClass.getClass() + ", reason : " + e.getMessage()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)("could not obtain beanInfo for " + valueClass.getClass() + ", reason : " + e.getMessage()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("could not obtain beanInfo for " + valueClass.getClass() + ", reason : " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static EventSetDescriptor getPropertyChangeListenerDescriptor(Class beanClass) {
        try {
            EventSetDescriptor[] events;
            BeanInfo infos = Introspector.getBeanInfo(beanClass);
            for (EventSetDescriptor event : events = infos.getEventSetDescriptors()) {
                if (!"propertyChange".equals(event.getName())) continue;
                if (event.getAddListenerMethod() == null) {
                    throw new IllegalStateException("no addPropertyChangeListener method found for " + beanClass);
                }
                if (event.getRemoveListenerMethod() == null) {
                    throw new IllegalStateException("no removePropertyChangeListener method found for " + beanClass);
                }
                return event;
            }
            throw new IllegalStateException("no PropertyChangeListener access method found for " + beanClass);
        }
        catch (IntrospectionException ex) {
            throw new IllegalStateException("could not acquire PropertyChangeListener bean info for " + beanClass + " for reason " + ex.getMessage(), ex);
        }
    }
}

