package jaxx.runtime.swing;

import jaxx.runtime.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryStatusWidget extends javax.swing.JComponent implements ActionListener, jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.MemoryStatusWidget.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdX2KHOAnki1R8hJAgqjPQIGHEV5BFIhskjESEG9a+jb3hfLfszsUXCoREi1AqChqgp6RHiJKKlv+AEP+A2T3bZ4MVcsXeafa92fd23n38CVmt4MwOi2NXRQGKNnc3b25t3avv8Abe5rqhhMRQQfJkHHBqMOX16xrhbK1s6IUuvbAetmUY8GCAXSxDXuOez3WLc0Q4njAaWheq/XIxlpHqdeuLGdXt/e9fzr734oMDEEtSlSMLy/9jpQ7Gy+AID2GeTtplBZ8FTZKhRNAknTOmtu4zre+yNn8Kz2GiDDnJFDVDWDm8VdvD8mOJML262QdfQFgbUqs7dLZb4e1Q7VWRYaQfCq/JUUrbIIeQNTiFMGfUxV3CA1NLMfNShU3Ftb7FGk+aKowC8njUEFzWQboSPxyFLoWKJ2izM5ciFlar1tNGIFAwXzzj6iLCaau8QV6Ez5X7D+RA/iWztUQQBQtJH63dNAHpiDI1yKqIygiztTQs96mUxKRbtQ1s9d3Lt7tvPn2+0svEGJ0xMwQZiDDNiOxLulFhjjiWBCFC4RcqTBZrMKm5T/m3+V4cEFDtlkkE9bfTcA3NvcN0i6jZiR9fvi49/j4GTgnyfsi8EjP4DZjEFt12K/S9WF6/YZVMd47QOms0IeTrg1O76jFky3UReDToazEZXhww3Ffxbf9V5cTrk5d7pjOJqL9gqfHsI8iJwBcBt79AN90jIz8lNY+8ME3xqFxnzDsvuzM/ZdeVUe7Gt8MAze5aHJnXOSvWfJ0/dI/89lBSD+j0BxyhP6HWBAAA";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected java.awt.Color progressBackground;
    protected java.awt.Color progressForeground;
    protected javax.swing.Timer timer;
    private jaxx.runtime.swing.MemoryStatusWidget $JComponent0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource4 = new jaxx.runtime.DataBindingListener($JComponent0, "$JComponent0.font");

    /* begin raw body code */
    private final static String memoryTestStr = "99999/99999Mb";
    private FontRenderContext frc;
    private LineMetrics lm;
    
    
    @Override
    public void actionPerformed(ActionEvent evt) {
        repaint();
    }
    
    /** Adds a feature to the Notify attribute of the MemoryStatus object */
    @Override
    public void addNotify() {
        super.addNotify();
        setTimer(new javax.swing.Timer(2000, this));
        timer.start();
    }
    
    @Override
    public void removeNotify() {
        if (timer != null) {
            timer.stop();
            timer = null;
        }
        super.removeNotify();
    }
    
    @Override
    public void paintComponent(Graphics g) {
        Insets insets = new Insets(0, 0, 0, 0);
        Runtime runtime = Runtime.getRuntime();
        int freeMemory = (int) (runtime.freeMemory() / 1024L);
        int totalMemory = (int) (runtime.totalMemory() / 1024L);
        int usedMemory = totalMemory - freeMemory;
        int width = getWidth() - insets.left - insets.right;
        int height = getHeight() - insets.top - insets.bottom - 1;
        float fraction = (float) usedMemory / (float) totalMemory;
        g.setColor(progressBackground);
        g.fillRect(insets.left, insets.top, (int) ((float) width * fraction), height);
        // No i18n string was :
        // String str = usedMemory / 1024 + "/" + totalMemory / 1024 + "Mb";
        String str = _("memorywidget.memory", usedMemory / 1024, totalMemory / 1024);
        //FontRenderContext frc = new FontRenderContext(null, false, false);
        Rectangle2D bounds = g.getFont().getStringBounds(str, frc);
        Graphics g2 = g.create();
        g2.setClip(insets.left, insets.top,
                (int) ((float) width * fraction), height);
        g2.setColor(progressForeground);
        g2.drawString(str, insets.left
                + (int) ((double) width - bounds.getWidth()) / 2,
                (int) ((float) insets.top + lm.getAscent()));
        g2.dispose();
        g2 = g.create();
        g2.setClip(insets.left + (int) ((float) width * fraction),
                insets.top, getWidth() - insets.left
                        - (int) ((float) width * fraction), height);
        g2.setColor(getForeground());
        g2.drawString(str, insets.left
                + (int) ((double) width - bounds.getWidth()) / 2,
                (int) ((float) insets.top + lm.getAscent()));
        g2.dispose();
    }
    
    
    void $afterCompleteSetup() {
        //FontRenderContext frc = new FontRenderContext(null, false, false);
        Rectangle2D bounds = getFont().getStringBounds(memoryTestStr, frc);
        Dimension dim = new Dimension((int) bounds.getWidth(), (int) bounds .getHeight());
        setPreferredSize(dim);
        setMaximumSize(dim);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public MemoryStatusWidget() {
        $initialize();
    }

    public MemoryStatusWidget(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JComponent0.font".equals($binding)) {
            if (new JLabel() != null) {
                new JLabel().addPropertyChangeListener("font", $DataSource4);
            }
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JComponent0.font".equals($dest)) {
            if (new JLabel() != null) {
                $JComponent0.setFont((new JLabel().getFont()));
            }
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JComponent0.font".equals($binding)) {
            if (new JLabel() != null) {
                new JLabel().removePropertyChangeListener("font", $DataSource4);
            }
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public java.awt.Color getProgressBackground() {
        return progressBackground;
    }

    public java.awt.Color getProgressForeground() {
        return progressForeground;
    }

    public javax.swing.Timer getTimer() {
        return timer;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setProgressBackground(java.awt.Color newValue) {
        java.awt.Color oldValue = this.progressBackground;
        this.progressBackground = newValue;
        firePropertyChange("progressBackground", oldValue, newValue);
    }

    public void setProgressForeground(java.awt.Color newValue) {
        java.awt.Color oldValue = this.progressForeground;
        this.progressForeground = newValue;
        firePropertyChange("progressForeground", oldValue, newValue);
    }

    public void setTimer(javax.swing.Timer newValue) {
        javax.swing.Timer oldValue = this.timer;
        this.timer = newValue;
        firePropertyChange("timer", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected jaxx.runtime.swing.MemoryStatusWidget get$JComponent0() {
        return $JComponent0;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        
        
        $JComponent0.setBackground((Color.WHITE));
        applyDataBinding("$JComponent0.font");
        $JComponent0.setForeground((Color.BLACK));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JComponent0", this);
        createTimer();
        createProgressBackground();
        createProgressForeground();
        
        frc = new FontRenderContext(null, false, false);
        
        lm = new JLabel().getFont().getLineMetrics(memoryTestStr, frc);
        
        $JComponent0.setName("$JComponent0");
        
        
        $completeSetup();
    }

    protected void createProgressBackground() {
        progressBackground = Color.decode("#666699a");
        $objectMap.put("progressBackground", progressBackground);
    }

    protected void createProgressForeground() {
        progressForeground = Color.decode("#cccccc");
        $objectMap.put("progressForeground", progressForeground);
    }

    protected void createTimer() {
        timer = null;
        $objectMap.put("timer", timer);
    }

}
