package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.Timer;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class JProgressBarDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_FOREGROUND = "$JLabel0.foreground";
    private static final String BINDING_$JPROGRESS_BAR0_FOREGROUND = "$JProgressBar0.foreground";
    private static final String BINDING_$JPROGRESS_BAR0_VALUE = "$JProgressBar0.value";
    private static final String BINDING_$JPROGRESS_BAR1_FOREGROUND = "$JProgressBar1.foreground";
    private static final String BINDING_$JPROGRESS_BAR1_VALUE = "$JProgressBar1.value";
    private static final String BINDING_$JPROGRESS_BAR2_FOREGROUND = "$JProgressBar2.foreground";
    private static final String BINDING_$JPROGRESS_BAR2_VALUE = "$JProgressBar2.value";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUS08TURS+rRQoaNU2EoyYgFbjI04RXxgIIJBGalViNSF0423n0g6Zx/XeOzC6MP4Ef4Lu3Zi4c2VcuHbhxvgXjHHh1njunT5lmGloFzPNOd/5znfOnfu9+4kSnKGpbex5GnNtYVhEK9zZ2HhY2SZVsUp4lRlUOAz5v1gcxctoVG/FuUBny0VZnmuU51Ycizo2sTuq54pohIvnJuF1QoRAp7srqpznSq30nEdd1mRtiQpiffP7V/y1/uptHCGPgro0jDIZVdWeZKCI4oYuUBo67eCcie0ayGCGXQO9R2RsxcScP8AWeYZeoqEiGqSYAZlAZ3ofWXGoeo8KNJpdJZazjm1iTgt0SYnVIaJVmxQa3wUFWmGdOTVGOF/GTJZQqkgGBcpkS6rHmm0IA5vGC8KA6ryikiyGSZjmy9D2IENprspUKhQyEw25Fg25Hg25EQ25GQ25FQ2ZjYbc/g+S1JtnKNB41/fmn91jXDFJGz6cLRRxRR14Wn5VXvOIVVSCplrYVLbz4KcVf0dFRy6sTh3kxTDETAAimS0su0I4NrTNdLX1w/ugVbPpRpKhU10Lgautta92++7FyijBXAjDhOW9bvAIUr4PjP/nA5JQZf+OZb59/PEh37z8Keh9IhDa4V1wKSlzKGHCkK2P+jffFYaZu4/pXBklOTHB+JSxTQQIKzXSIA76HZflmizX7mJeB4rE0PdPn8eefj2E4nk0YjpYz2OJX0NJUYfd1x1T9+jiklJ0eHcYnsekNoEGthzpLKl5HQs8WTFsHVa/4MEKJgJW0NJRSX75kym9X2quIQayTu4Lb68isYkGDds0bKJcsGFwga43SjlxdadtZEHWFpPvc7Tx1c+q53zQnCNbDiM15ri2arroufK1pKTLf8s9Mw0I4sHG0vP+HJNYgHlXXEEWDsopw/kQVRd6UDVkYc+wXEsCigenSexg0yV9aYma5nJPDE9CBumNYbNvDWFTXOl7it4YwqbojeFeiIZc3wwzwPAPITzZ2s8JAAA=";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JProgressBarDemo $DemoPanel0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JProgressBar $JProgressBar0;
    private javax.swing.JProgressBar $JProgressBar1;
    private javax.swing.JProgressBar $JProgressBar2;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    int red;
    int green;
    int blue;
    int speed;
    int redDirection;
    int greenDirection;
    int blueDirection;
    Timer redTimer;
    Timer greenTimer;
    Timer blueTimer;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JProgressBarDemo() {
        super();
        $initialize();
    }

    public JProgressBarDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        redTimer.start(); greenTimer.start(); blueTimer.start();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        redTimer.stop(); greenTimer.stop(); blueTimer.stop();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JProgressBar get$JProgressBar0() {
        return $JProgressBar0;
    }

    protected javax.swing.JProgressBar get$JProgressBar1() {
        return $JProgressBar1;
    }

    protected javax.swing.JProgressBar get$JProgressBar2() {
        return $JProgressBar2;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDemoPanel() {
        if (!allComponentsCreated) {
            return;
        }
        demoPanel.add($JLabel0, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
        demoPanel.add($JProgressBar0, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        demoPanel.add($JProgressBar1, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        demoPanel.add($JProgressBar2, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        demoPanel.add($JButton0, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(6, 6, 6, 6), 0, 0));
        demoPanel.add($JButton1, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
    }

    protected void create$ScriptInitializer7() {
        redTimer = new Timer(5, new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    jaxx.runtime.Util.assignment(red = Math.max(0, Math.min(255, red + speed * redDirection)), "red", jaxx.demo.component.swing.JProgressBarDemo.this);
                    if (red == 0 || red == 255)
                        jaxx.runtime.Util.assignment(redDirection = -redDirection, "redDirection", jaxx.demo.component.swing.JProgressBarDemo.this);
                }
            });
    }

    protected void create$ScriptInitializer8() {
        greenTimer = new Timer(50, new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    jaxx.runtime.Util.assignment(green = Math.max(0, Math.min(255, green + speed * greenDirection)), "green", jaxx.demo.component.swing.JProgressBarDemo.this);
                    if (green == 0 || green == 255)
                        jaxx.runtime.Util.assignment(greenDirection = -greenDirection, "greenDirection", jaxx.demo.component.swing.JProgressBarDemo.this);
                }
            });
    }

    protected void create$ScriptInitializer9() {
        blueTimer = new Timer(500, new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    jaxx.runtime.Util.assignment(blue = Math.max(0, Math.min(255, blue + speed * blueDirection)), "blue", jaxx.demo.component.swing.JProgressBarDemo.this);
                    if (blue == 0 || blue == 255)
                        jaxx.runtime.Util.assignment(blueDirection = -blueDirection, "blueDirection", jaxx.demo.component.swing.JProgressBarDemo.this);
                }
            });
    }

    @Override
    protected void createDemoPanel() {
        $objectMap.put("demoPanel", demoPanel = new jaxx.runtime.swing.Table());
        demoPanel.setName("demoPanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToDemoPanel();
        
        // apply 7 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        $JLabel0.setFont(UIManager.getFont("Label.font").deriveFont(18f));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 7 data bindings
        $registerDefaultBindings();
        $objectMap.put("$DemoPanel0", this);
        red = 0;
        green = 0;
        blue = 0;
        speed = 2;
        redDirection = 1;
        greenDirection = 1;
        blueDirection = 1;
        create$ScriptInitializer7();
        create$ScriptInitializer8();
        create$ScriptInitializer9();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("Welcome to the JAXX framework!"));
        // inline creation of $JProgressBar0
        $objectMap.put("$JProgressBar0", $JProgressBar0 = new javax.swing.JProgressBar());
        $JProgressBar0.setName("$JProgressBar0");
        $JProgressBar0.setMaximum(255);
        // inline creation of $JProgressBar1
        $objectMap.put("$JProgressBar1", $JProgressBar1 = new javax.swing.JProgressBar());
        $JProgressBar1.setName("$JProgressBar1");
        $JProgressBar1.setMaximum(255);
        // inline creation of $JProgressBar2
        $objectMap.put("$JProgressBar2", $JProgressBar2 = new javax.swing.JProgressBar());
        $JProgressBar2.setName("$JProgressBar2");
        $JProgressBar2.setMaximum(255);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("Start"));
        $JButton0.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("Stop"));
        $JButton1.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        redTimer.start();greenTimer.start();blueTimer.start();$completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_FOREGROUND, true ,"red" ,"green" ,"blue") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setForeground(new Color(red, green, blue));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR0_FOREGROUND, true ,"red") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar0.setForeground(new Color(red, 0, 0));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR0_VALUE, true ,"red") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar0.setValue(red);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR1_FOREGROUND, true ,"green") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar1.setForeground(new Color(0, green, 0));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR1_VALUE, true ,"green") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar1.setValue(green);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR2_FOREGROUND, true ,"blue") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar2.setForeground(new Color(0, 0, blue));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR2_VALUE, true ,"blue") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar2.setValue(blue);
            }
        });
    }

}