package org.nuiton.jaxx.application.swing.action;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

import javax.swing.AbstractButton;
import javax.swing.Action;

import static org.nuiton.i18n.I18n.t;

/**
 * Factory of actions.
 * <p/>
 * Created on 11/24/13.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public class ApplicationActionFactory {

    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractApplicationUIHandler handler,
                                                                                       Class<A> actionName) {
        return createUIAction(handler, null, actionName);
    }


    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractApplicationUIHandler handler,
                                                                                       AbstractButton abstractButton,
                                                                                       Class<A> actionName) {
        try {

            // create logic action
            A logicAction = createLogicAction(handler, actionName);

            // create ui action
            ApplicationUIAction<A> result = createUIAction(abstractButton, logicAction);
            return result;
        } catch (Exception e) {
            throw new ApplicationTechnicalException(t("jaxx.application.action.create.error", actionName), e);
        }

    }

    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractButton abstractButton,
                                                                                       A logicAction) {

        // create ui action
        ApplicationUIAction<A> result = new ApplicationUIAction<A>(abstractButton,
                                                                   logicAction);
        return result;


    }

    public <A extends AbstractApplicationAction> A createLogicAction(AbstractApplicationUIHandler handler,
                                                                     Class<A> actionName) {
        try {

            // create action
            A result = ConstructorUtils.invokeConstructor(actionName, handler);
            return result;
        } catch (Exception e) {
            throw new ApplicationTechnicalException(t("jaxx.application.action.create.error", actionName), e);
        }
    }

    public <A extends AbstractApplicationAction> A getLogicAction(AbstractButton b) {
        Action action = b.getAction();
        Preconditions.checkNotNull(action);
        Preconditions.checkState(action instanceof ApplicationUIAction);
        return ((ApplicationUIAction<A>) action).getLogicAction();
    }
}
