/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.FileUpdaterHelper;
import org.nuiton.io.SortedProperties;
import org.nuiton.processor.filters.DefaultFilter;

public class ParserJavaMojo
extends AbstractI18nParserMojo {
    protected File defaultBasedir;
    protected String defaultIncludes;
    protected String outputGetter;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return FileUpdaterHelper.newJavaFileUpdater((File)entry.getBasedir(), (File)this.cp);
    }

    @Override
    @Deprecated
    protected String getKeyModifierStart() {
        return "_\\(\\s*\"";
    }

    @Override
    @Deprecated
    protected String getKeyModifierEnd() {
        return "\"\\s*(\\)|,|\\+|$)";
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    public FileParser newFileParser() {
        return new JavaFileParser(this.getLog(), this.getEncoding(), this.oldParser, this.isShowTouchedFiles());
    }

    public static class I18nFilter
    extends DefaultFilter {
        private final Log log;
        private String header = "^_\\(\\s*\\\"|[^l]_\\(\\s*\\\"|l_\\([^,]+\\s*,\\s*\\\"";
        private String footer = "\"\\s*(\\)|,|\\+|$)";
        private Pattern headerPattern = Pattern.compile(this.getHeader());
        private Pattern footerPattern = Pattern.compile(this.getFooter());
        private Matcher matcher;

        public I18nFilter(Log log) {
            this.log = log;
        }

        protected void setFooter(String footer) {
            this.footer = footer;
        }

        protected void setHeader(String header) {
            this.header = header;
        }

        protected String getHeader() {
            return this.header;
        }

        protected String getFooter() {
            return this.footer;
        }

        public int getMatchIndexFor(String input, String sequence) {
            int index;
            block6: {
                index = -1;
                this.setMatcher(null);
                if (sequence.equals(this.getHeader())) {
                    this.setMatcher(this.getHeaderPattern().matcher(input));
                } else if (sequence.equals(this.getFooter())) {
                    this.setMatcher(this.getFooterPattern().matcher(input));
                }
                if (this.getMatcher() != null) {
                    try {
                        this.getMatcher().find();
                        index = this.getMatcher().start();
                    }
                    catch (RuntimeException e) {
                        if (!this.log.isDebugEnabled()) break block6;
                        this.log.debug((CharSequence)("Could not match with " + this.getMatcher() + " input " + input));
                    }
                }
            }
            return index;
        }

        public int getMatchLengthFor(String sequence) {
            int length;
            block2: {
                length = -1;
                try {
                    length = this.getMatcher().end() - this.getMatcher().start();
                }
                catch (RuntimeException e) {
                    if (!this.log.isDebugEnabled()) break block2;
                    this.log.debug((CharSequence)("Could not match with " + this.getMatcher() + " input " + sequence));
                }
            }
            return length;
        }

        protected String performInFilter(String ch) {
            return ch.replaceAll("\"\\s*\\+\\s*\"", "") + "=";
        }

        public String performHeaderFooterFilter(String ch) {
            return ch.substring(ch.indexOf(34) + 1, ch.lastIndexOf(34));
        }

        protected String performOutFilter(String ch) {
            return "";
        }

        protected Pattern getFooterPattern() {
            return this.footerPattern;
        }

        protected Pattern getHeaderPattern() {
            return this.headerPattern;
        }

        protected Matcher getMatcher() {
            return this.matcher;
        }

        protected void setMatcher(Matcher matcher) {
            this.matcher = matcher;
        }
    }

    protected static class JavaFileParser
    extends AbstractFileParser {
        protected final I18nFilter filter;

        public JavaFileParser(Log log, String encoding, SortedProperties oldParser, boolean showTouchedFiles) {
            super(log, encoding, oldParser, showTouchedFiles);
            this.filter = new I18nFilter(log);
        }

        @Override
        public void parseFile(File file) throws IOException {
            String line = null;
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), this.getEncoding()));
            try {
                while ((line = lnr.readLine()) != null) {
                    this.parseLine(file, line);
                }
            }
            catch (Exception e) {
                if (line != null) {
                    this.getLog().error((CharSequence)("could not parse line (" + lnr.getLineNumber() + ") '" + line + "' of file " + file));
                }
                throw new ParserException(e);
            }
            finally {
                lnr.close();
            }
        }

        @Override
        public void parseLine(File file, String line) throws IOException {
            String[] keys;
            String keysSet = this.filter.parse(line);
            if (keysSet.equals("")) {
                return;
            }
            this.setTouched(true);
            for (String key : keys = keysSet.split("=")) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(file.getName() + " detected key = " + key));
                }
                this.registerKey(key);
            }
        }
    }
}

