/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.i18n.plugin.bundle.AbstractI18nBundleMojo;

public abstract class AbstractMakeI18nBundleMojo
extends AbstractI18nBundleMojo {
    protected File bundleOutputDir;
    protected String bundleOutputName;
    protected boolean generateDefaultLocale;
    protected boolean checkBundle;
    protected boolean showEmpty;
    protected boolean failsIfWarning;
    protected Map<Locale, SortedSet<String>> unsafeMapping;

    @Override
    public void init() throws Exception {
        super.init();
        if (this.failsIfWarning) {
            this.checkBundle = true;
            this.unsafeMapping = new HashMap<Locale, SortedSet<String>>();
        } else {
            this.unsafeMapping = null;
        }
        this.createDirectoryIfNecessary(this.bundleOutputDir);
    }

    protected void failsIfWarning() throws MojoFailureException {
        if (!this.failsIfWarning) {
            return;
        }
        if (this.unsafeMapping != null && !this.unsafeMapping.isEmpty()) {
            throw new MojoFailureException("Bundles for locale(s) " + this.unsafeMapping.keySet() + " are not complete. Use the -Di18n.showEmpty to see " + "missing translations.");
        }
    }

    protected abstract File getBundleFile(File var1, String var2, Locale var3, boolean var4) throws IOException;

    protected void generateDefaultBundle() throws IOException {
        File bundleFirstLocale = this.getBundleFile(this.bundleOutputDir, this.bundleOutputName, this.locales[0], false);
        File bundleWithoutLocale = this.getBundleFile(this.bundleOutputDir, this.bundleOutputName, null, false);
        if (!this.isSilent()) {
            this.getLog().info((CharSequence)("Generate default bundle at " + bundleWithoutLocale));
        }
        FileUtils.copyFile((File)bundleFirstLocale, (File)bundleWithoutLocale);
    }
}

