/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.plugin.bundle.AbstractMakeI18nBundleMojo;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

public class BundleMojo
extends AbstractMakeI18nBundleMojo {
    protected boolean addBundleOuputDirParent;
    protected boolean generateDefinitionFile;

    @Override
    public void init() throws Exception {
        super.init();
        File ressourceDir = this.bundleOutputDir;
        if (this.addBundleOuputDirParent) {
            ressourceDir = ressourceDir.getParentFile();
        }
        this.addResourceDir(ressourceDir, new String[]{"**/*.properties"});
    }

    protected void doAction() throws Exception {
        long t00 = System.nanoTime();
        String version = this.getProject().getVersion();
        version = PluginHelper.removeSnapshotSuffix((String)version);
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - bundle name : " + this.bundleOutputName));
            this.getLog().info((CharSequence)("config - basedir     : " + this.bundleOutputDir));
            this.getLog().info((CharSequence)("config - locales     : " + Arrays.toString(this.locales)));
            this.getLog().info((CharSequence)("config - version     : " + version));
        }
        LinkedHashMap<Locale, String> bundleDico = new LinkedHashMap<Locale, String>(this.locales.length);
        for (Locale locale : this.locales) {
            long t0 = System.nanoTime();
            File bundleOut = this.getI18nFile(this.bundleOutputDir, this.bundleOutputName, locale, false);
            SortedProperties propertiesOut = new SortedProperties(this.encoding, false);
            StringBuilder buffer = new StringBuilder();
            URL[] urls = this.getCollectI18nResources(locale);
            if (urls.length == 0) {
                this.getLog().warn((CharSequence)("no bundle for locale " + locale));
                continue;
            }
            if (!this.silent) {
                this.getLog().info((CharSequence)("generate bundle for locale " + locale + " from " + urls.length + " i18n resource(s)"));
            }
            ArrayList<String> bundlesUrls = new ArrayList<String>();
            for (URL url : urls) {
                long t000 = System.nanoTime();
                I18nBundleEntry bundleEntry = new I18nBundleEntry(url, locale, null);
                bundleEntry.load((Properties)propertiesOut);
                String strPath = bundleEntry.getPath().toString();
                int index = strPath.indexOf("i18n/");
                String str = strPath.substring(index);
                bundlesUrls.add(str);
                buffer.append(',').append(str);
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)("loaded " + bundleEntry.getPath() + " in " + PluginHelper.convertTime((long)t000, (long)System.nanoTime())));
            }
            if (!bundlesUrls.isEmpty()) {
                bundleDico.put(locale, buffer.substring(1));
                if (!this.silent) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(bundlesUrls.size() + " i18n resource(s) detected"));
                    }
                    for (String u : bundlesUrls) {
                        this.getLog().info((CharSequence)u);
                    }
                }
            }
            propertiesOut.store(bundleOut);
            if (!this.silent && this.verbose) {
                this.getLog().info((CharSequence)("bundle created in " + PluginHelper.convertTime((long)t0, (long)System.nanoTime()) + " (detected sentences : " + propertiesOut.size() + ")"));
            }
            if (!this.checkBundle) continue;
            this.checkBundle(locale, (Properties)propertiesOut, this.showEmpty, this.unsafeMapping);
        }
        this.failsIfWarning();
        if (this.generateDefinitionFile) {
            this.generateDefinitionFile(version, bundleDico);
        }
        if (!this.silent && this.verbose) {
            this.getLog().info((CharSequence)("done in " + PluginHelper.convertTime((long)t00, (long)System.nanoTime())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateDefinitionFile(String version, Map<Locale, String> bundleDico) throws IOException {
        String f = String.format(DefaultI18nInitializer.UNIQUE_BUNDLE_DEF, this.bundleOutputName);
        File defOut = new File(this.bundleOutputDir, f);
        if (!this.silent) {
            this.getLog().info((CharSequence)("prepare i18n definition file in " + defOut.getAbsolutePath()));
        }
        SortedProperties p = new SortedProperties(this.encoding, false);
        p.setProperty(DefaultI18nInitializer.BUNDLE_DEF_LOCALES, this.bundles);
        p.setProperty(DefaultI18nInitializer.BUNDLE_DEF_VERSION, version);
        for (Map.Entry<Locale, String> e : bundleDico.entrySet()) {
            p.setProperty(DefaultI18nInitializer.BUNDLES_FOR_LOCALE + e.getKey().toString(), e.getValue());
        }
        FileOutputStream out = new FileOutputStream(defOut);
        try {
            p.store((OutputStream)out, null);
        }
        finally {
            out.close();
        }
    }

    @Override
    protected URL[] getCollectI18nResources(Locale locale) throws IOException {
        File file = this.getCollectOutputFile(locale, false);
        if (!file.exists()) {
            return I18nBundleUtil.EMPTY_URL_ARRAY;
        }
        URL[] urls = PluginHelper.getLinesAsURL((File)file);
        return urls;
    }
}

