/*
 * #%L
 * I18n :: Maven Plugin
 * 
 * $Id: ParserXmlMojo.java 1795 2010-11-11 10:52:30Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/i18n/tags/i18n-2.0.1/maven-i18n-plugin/src/main/java/org/nuiton/i18n/plugin/parser/impl/ParserXmlMojo.java $
 * %%
 * Copyright (C) 2007 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.i18n.plugin.parser.impl;

import org.apache.maven.plugin.logging.Log;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.io.SortedProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

/**
 * Récupération des chaines à traduire depuis les fichiers xml.
 *
 * @author julien
 * @deprecated since 2.0, prefer use the {@link AbstractParserXmlMojo} instead.
 */
@Deprecated
public abstract class ParserXmlMojo extends AbstractI18nParserMojo {

    /** Taille du buffer pour les lectures/écritures */
    protected static final int BUFFER_SIZE = 8 * 1024;

    protected String rules;

    protected XPathFactory factory;

    protected DocumentBuilderFactory documentBuilderFactory;

    /** @return le fichier des rules */
    protected abstract String getFileRules();

    /** @return le fichier des rules de base à toujours charger */
    protected abstract String getCoreFileRules();

    protected abstract XmlFileParser newXmlFileParser(XPath xpath,
                                                      DocumentBuilder builder);

    @Override
    public void init() throws Exception {
        super.init();
        factory = XPathFactory.newInstance();
        rules = getRules(getFileRules());

        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
    }

    @Override
    public final FileParser newFileParser() {

        DocumentBuilder builder;
        try {
            // never forget this!
            builder = documentBuilderFactory.newDocumentBuilder();
        } catch (ParserConfigurationException ex) {
            throw new IllegalStateException(
                    "could not load DocumentBuilder for reason " +
                    ex.getMessage(), ex);
        }

        XPath xpath = factory.newXPath();

        return newXmlFileParser(xpath, builder);
    }

    /**
     * Récupère le xpath à partir d'un fichier
     *
     * @param fileRules le nom du fichier contant les règles
     * @return le xpath à partir d'un fichier
     */
    private String getRules(String fileRules) {
        StringBuilder buffer = new StringBuilder();

        try {
            String readInputStream;

            // load core rules
            readInputStream = loadRulesFile(getCoreFileRules());
            if (!silent && verbose) {
                getLog().info("core rules : " + getCoreFileRules());
            }
            buffer.append(readInputStream);

            if (!fileRules.equals(getCoreFileRules())) {
                // add custom rules
                readInputStream = loadRulesFile(fileRules);
                if (!silent && verbose) {
                    getLog().info("custom rules : " + fileRules);
                }
                buffer.append(" | ").append(readInputStream);
            }
        } catch (IOException e) {
            throw new ParserException(e);
        }

        return buffer.toString();
    }

    private String loadRulesFile(String fileRules) throws IOException {
        File f = new File(fileRules);

        InputStream inputStream;
        if (f.exists()) {
            // load from a file
            try {
                inputStream = new FileInputStream(f);
            } catch (FileNotFoundException e) {
                throw new ParserException(e);
            }
        } else {
            // load from classpath
            ClassLoader classLoader = getClass().getClassLoader();
            inputStream = classLoader.getResourceAsStream(fileRules);
        }
        if (inputStream == null) {
            throw new ParserException(
                    "could not found file of rules : " + fileRules);
        }

        inputStream = new BufferedInputStream(inputStream);

        try {
            // Lecture
            String readInputStream;
            readInputStream = readInputStream(inputStream);
            return readInputStream;
        } catch (IOException e) {
            throw new ParserException(e);
        } finally {
            inputStream.close();
        }
    }

    /**
     * Permet la lecture d'un InputStream et Suppressions.
     *
     * @param in le flux entrant
     * @return le contenu du flux
     * @throws IOException si problème de lecture dans flux entrant
     */
    private String readInputStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[BUFFER_SIZE];
        while (in.read(buffer, 0, BUFFER_SIZE) != -1) {
            String tmp = new String(buffer);
            sb.append(tmp);
        }
        in.close();
        // Suppression
        String txt = sb.toString().trim();
        // suppression des commentaires
        txt = txt.replaceAll("#.*\n", "");
        // contruction du xpath avec des ou
        txt = txt.replaceAll("\\s+", " | ");
        // suppression des ou de début ee fin
        txt = txt.replaceAll("(^ \\| )|( \\| $)", "");
        return txt;
    }

    public static abstract class XmlFileParser extends AbstractFileParser {

        private final XPath xpath;

        private final String rules;

        private final DocumentBuilder builder;

        /**
         * Fonction d'extraction de la chaine
         *
         * @param i18nString le clef i18n
         * @return la chaine
         */
        public abstract String extract(String i18nString);

        public XmlFileParser(Log log,
                             String encoding,
                             SortedProperties oldParser,
                             boolean showTouchedFiles,
                             String rules,
                             XPath xpath,
                             DocumentBuilder builder) {
            super(log, encoding, oldParser, showTouchedFiles);
            this.xpath = xpath;
            this.rules = rules;
            this.builder = builder;

        }

        @Override
        public void parseFile(File file) throws IOException {

            try {

                // Recherche des clés à partir d'un xpath

                Document doc = builder.parse(file.getAbsolutePath());
                XPathExpression expression = xpath.compile(rules);
                NodeList list = (NodeList)
                        expression.evaluate(doc, XPathConstants.NODESET);

                for (int index = 0; index < list.getLength(); index++) {
                    Node node = list.item(index);
                    parseLine(file, node.getTextContent());
                }
            } catch (Exception e) {
                throw new ParserException(e);
            }
        }

        @Override
        public void parseLine(File file, String key) throws IOException {

            key = extract(key);
            if (key != null) {
                setTouched(true);
                registerKey(key);
            }
        }
    }
}
