/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.plugin.bundle.AbstractI18nBundleMojo;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

public class BundleMojo
extends AbstractI18nBundleMojo {
    protected File bundleOutputDir;
    protected String bundleOutputName;
    protected boolean checkBundle;
    protected boolean showEmpty;

    @Override
    public void init() throws Exception {
        super.init();
        this.createDirectoryIfNecessary(this.bundleOutputDir);
        this.addResourceDir(this.bundleOutputDir.getParentFile(), new String[]{"**/*.properties"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        long t00 = System.nanoTime();
        String version = this.getProject().getVersion();
        version = PluginHelper.removeSnapshotSuffix((String)version);
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - bundle name : " + this.bundleOutputName));
            this.getLog().info((CharSequence)("config - basedir     : " + this.bundleOutputDir));
            this.getLog().info((CharSequence)("config - locales     : " + Arrays.toString(this.locales)));
            this.getLog().info((CharSequence)("config - version     : " + version));
        }
        LinkedHashMap<Locale, String> bundleDico = new LinkedHashMap<Locale, String>(this.locales.length);
        for (Locale locale : this.locales) {
            long t0 = System.nanoTime();
            File bundleOut = this.getI18nFile(this.bundleOutputDir, this.bundleOutputName, locale, false);
            SortedProperties propertiesOut = new SortedProperties(this.encoding, false);
            StringBuilder buffer = new StringBuilder();
            URL[] urls = this.getCollectI18nResources(locale);
            if (urls.length == 0) {
                this.getLog().warn((CharSequence)("no bundle for locale " + locale));
                continue;
            }
            if (!this.silent) {
                this.getLog().info((CharSequence)("generate bundle for locale " + locale + " from " + urls.length + " i18n resource(s)"));
            }
            ArrayList<String> bundlesUrls = new ArrayList<String>();
            for (URL url : urls) {
                long t000 = System.nanoTime();
                I18nBundleEntry bundleEntry = new I18nBundleEntry(url, locale, null);
                bundleEntry.load((Properties)propertiesOut);
                String strPath = bundleEntry.getPath().toString();
                int index = strPath.indexOf("i18n/");
                String str = strPath.substring(index);
                bundlesUrls.add(str);
                buffer.append(',').append(str);
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)("loaded " + bundleEntry.getPath() + " in " + PluginHelper.convertTime((long)t000, (long)System.nanoTime())));
            }
            if (!bundlesUrls.isEmpty()) {
                bundleDico.put(locale, buffer.substring(1));
                if (!this.silent) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(bundlesUrls.size() + " i18n resource(s) detected"));
                    }
                    for (String u : bundlesUrls) {
                        this.getLog().info((CharSequence)u);
                    }
                }
            }
            propertiesOut.store(bundleOut);
            if (!this.silent && this.verbose) {
                this.getLog().info((CharSequence)("bundle created in " + PluginHelper.convertTime((long)t0, (long)System.nanoTime()) + " (detected sentences : " + propertiesOut.size() + ")"));
            }
            if (!this.checkBundle) continue;
            this.checkBundle(locale, (Properties)propertiesOut, this.showEmpty);
        }
        String f = String.format(DefaultI18nInitializer.UNIQUE_BUNDLE_DEF, this.bundleOutputName);
        File defOut = new File(this.bundleOutputDir, f);
        if (!this.silent) {
            this.getLog().info((CharSequence)("prepare i18n definition " + defOut.getAbsolutePath()));
        }
        SortedProperties p = new SortedProperties(this.encoding, false);
        p.setProperty(DefaultI18nInitializer.BUNDLE_DEF_LOCALES, this.bundles);
        p.setProperty(DefaultI18nInitializer.BUNDLE_DEF_VERSION, version);
        for (Map.Entry e : bundleDico.entrySet()) {
            p.setProperty(DefaultI18nInitializer.BUNDLES_FOR_LOCALE + ((Locale)e.getKey()).toString(), (String)e.getValue());
        }
        FileOutputStream out = new FileOutputStream(defOut);
        try {
            p.store((OutputStream)out, null);
        }
        finally {
            out.close();
        }
        if (!this.silent && this.verbose) {
            this.getLog().info((CharSequence)("done in " + PluginHelper.convertTime((long)t00, (long)System.nanoTime())));
        }
    }

    @Override
    protected URL[] getCollectI18nResources(Locale locale) throws IOException {
        File file = this.getCollectOutputFile(locale, false);
        if (!file.exists()) {
            return I18nBundleUtil.EMPTY_URL_ARRAY;
        }
        URL[] urls = BundleMojo.getLinesAsURL(file);
        return urls;
    }
}

