/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.nuiton.i18n.plugin.parser.ParserEvent;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.plugin.PluginHelper;

public class KeysModifier
extends JFrame
implements ParserEvent {
    private static final long serialVersionUID = 1L;
    protected List<String> newKeys;
    protected boolean needModifiedFile;
    protected String patternLeft;
    protected String patternRight;
    protected String encoding;
    protected JLabel name = new JLabel();
    protected JLabel path = new JLabel();
    protected JTextField key = new JTextField();
    protected JTextField pattern = new JTextField(".*");
    protected JCheckBox onlyNewKey = new JCheckBox();
    protected JButton next = new JButton("Next >>");
    private static KeysModifier keysModifier;

    public static KeysModifier getInstance(String patternLeft, String patternRight, String encoding) {
        if (keysModifier == null) {
            keysModifier = new KeysModifier();
        }
        KeysModifier.keysModifier.encoding = encoding;
        KeysModifier.keysModifier.patternLeft = patternLeft;
        KeysModifier.keysModifier.patternRight = patternRight;
        return keysModifier;
    }

    private KeysModifier() {
        this.setLayout(new GridLayout(9, 2, 10, 10));
        Container pane = this.getContentPane();
        pane.add(new JLabel("--- File information ---"));
        pane.add(new JLabel());
        pane.add(new JLabel("Name :"));
        pane.add(this.name);
        pane.add(new JLabel("Path : "));
        pane.add(this.path);
        pane.add(new JLabel("--- Files language ---"));
        pane.add(new JLabel());
        pane.add(new JLabel("Key :"));
        pane.add(this.key);
        pane.add(new JLabel("--- Filters ---"));
        pane.add(new JLabel());
        pane.add(new JLabel("Pattern :"));
        pane.add(this.pattern);
        pane.add(new JLabel("Only new key :"));
        pane.add(this.onlyNewKey);
        pane.add(new JLabel());
        pane.add(this.next);
        this.next.addActionListener(new EventNextKey());
        this.addWindowListener(new EventWindows());
        this.setTitle("Keys modifier");
        this.setSize(800, 400);
        this.setVisible(true);
    }

    @Override
    public void eventChangeFile(File file) {
        this.name.setText(file.getName());
        this.path.setText(file.getPath());
        this.key.setText("");
        this.repaint();
        this.newKeys = new ArrayList<String>();
        this.needModifiedFile = false;
    }

    @Override
    public void eventNextFile(File file) {
        if (this.needModifiedFile) {
            String content;
            int region = 0;
            try {
                content = PluginHelper.readAsString((File)file, (String)this.encoding);
            }
            catch (IOException e) {
                throw new ParserException(e);
            }
            Iterator<String> iterator = this.newKeys.iterator();
            while (iterator.hasNext()) {
                String oldKey = iterator.next();
                String realKey = iterator.next();
                Pattern p = Pattern.compile('(' + this.patternLeft + ")(" + Pattern.quote(oldKey) + ")(" + this.patternRight + ')');
                Matcher matcher = p.matcher(content);
                matcher.region(region, content.length());
                matcher.find();
                region = matcher.start();
                content = matcher.replaceFirst("$1" + realKey + "$3");
            }
            try {
                PluginHelper.writeString((File)file, (String)content, (String)this.encoding);
            }
            catch (IOException e) {
                throw new ParserException(e);
            }
        }
    }

    @Override
    public synchronized void eventChangeKey(String keyI18n, boolean newKey) {
        this.key.setText(keyI18n);
        this.newKeys.add(this.key.getText());
        this.repaint();
        if (this.isVisible() && keyI18n.matches(this.pattern.getText()) && (!this.onlyNewKey.isSelected() || newKey)) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new ParserException(e);
            }
        }
    }

    @Override
    public String eventGetRealKey() {
        this.newKeys.add(this.key.getText());
        this.needModifiedFile |= !this.newKeys.get(this.newKeys.size() - 1).equals(this.newKeys.get(this.newKeys.size() - 2));
        return this.key.getText();
    }

    public synchronized void eventNextKey() {
        this.notifyAll();
    }

    class EventWindows
    extends WindowAdapter {
        EventWindows() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            KeysModifier.this.setVisible(false);
            KeysModifier.this.eventNextKey();
        }
    }

    class EventNextKey
    implements ActionListener {
        EventNextKey() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeysModifier.this.eventNextKey();
        }
    }
}

