/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.beans.Introspector;
import java.io.File;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.nuiton.i18n.plugin.AbstractI18nMojo;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.plugin.PluginHelper;

public class I18nLogger
extends SystemStreamLog {
    private SourceEntry entry;
    protected File file;
    protected String parser;

    public I18nLogger(AbstractI18nMojo parser) {
        this.parser = "i18n:" + Introspector.decapitalize(((Object)((Object)parser)).getClass().getSimpleName()) + " on " + parser.getArtifactId();
    }

    public void info(CharSequence content) {
        this.print(0, "INFO", null, ((Object)content).toString());
    }

    public void debug(CharSequence content) {
        this.print(0, "DEBUG", null, ((Object)content).toString());
    }

    public void infoEntry(String action, CharSequence content) {
        this.print(0, "INFO", action, this.entry.toString() + (content == null ? "" : " - " + ((Object)content).toString()));
    }

    public void infoFile(String action, String content) {
        this.print(2, "INFO", action, this.file.toString() + (content == null ? "" : " - " + content));
    }

    public void infoAction(String action, String content) {
        this.print(2, "INFO", action, content == null ? "" : " - " + content);
    }

    private void print(int start, String prefix, String context, String content) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(prefix).append("] [").append(this.parser).append("] ");
        for (int i = 0; i < start; ++i) {
            sb.append(' ');
        }
        if (context != null) {
            sb.append("<").append(context).append("> ");
        }
        sb.append(content);
        System.out.println(sb.toString());
    }

    public void setEntry(SourceEntry entry) {
        this.entry = entry;
    }

    public String getLogEntry(String msg, int nbFiles, long time, long all) {
        long now = System.nanoTime();
        long delta = now - time;
        String s = msg;
        if (time > 0L && all == 0L) {
            s = s + " (" + PluginHelper.convertTime((long)delta) + ")";
        }
        if (all > 0L) {
            s = s + "(total time:" + PluginHelper.convertTime((long)(now - all)) + ")";
        }
        if (nbFiles > 0) {
            s = s + " ( ~ " + PluginHelper.convertTime((long)((now - all) / (long)nbFiles)) + " / file)";
        }
        return s;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

