/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.plugin.bundle.AbstractI18nBundleMojo;
import org.nuiton.i18n.plugin.bundle.I18nArtifact;
import org.nuiton.plugin.DependencyUtil;
import org.nuiton.plugin.PluginHelper;

public class CollectI18nArtifactsMojo
extends AbstractI18nBundleMojo {
    protected ArtifactRepository localRepository;
    protected DependencyTreeBuilder dependencyTreeBuilder;
    protected ArtifactFactory factory;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactCollector collector;
    I18nArtifact[] i18nArtifacts;

    @Override
    public void init() throws Exception {
        super.init();
        PluginHelper.createDirectoryIfNecessary((File)this.collectOutputDir);
    }

    protected void doAction() throws Exception {
        this.i18nArtifacts = this.detectI18nArtifacts();
        if (this.i18nArtifacts.length == 0) {
            this.getLog().warn((CharSequence)"no i18n artifact detected.");
            return;
        }
        for (Locale locale : this.locales) {
            URL[] urls;
            if (!this.silent) {
                this.getLog().info((CharSequence)("generate collected i18n artifacts for locale " + locale));
            }
            if ((urls = this.getCollectI18nResources(locale)).length == 0) {
                this.getLog().warn((CharSequence)("no i18n bundles for locale " + locale));
                return;
            }
            File bundleOut = this.getCollectOutputFile(locale, true);
            this.storeCollectI18nResources(bundleOut, urls);
            this.getLog().info((CharSequence)("collected " + urls.length + " i18n artifacts for locale " + locale + " stored in " + bundleOut));
        }
    }

    @Override
    protected URL[] getCollectI18nResources(Locale locale) throws IOException, DependencyTreeBuilderException {
        Locale defaultLocale = this.locales[0];
        ArrayList<URL> urls = new ArrayList<URL>();
        for (I18nArtifact artifact : this.i18nArtifacts) {
            I18nBundleEntry[] bundleEntries;
            for (I18nBundleEntry bundleEntry : bundleEntries = artifact.getBundleEntries(locale, defaultLocale)) {
                URL path = bundleEntry.getPath();
                urls.add(path);
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)("add " + path));
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    protected void storeCollectI18nResources(File bundleOut, URL[] urls) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (URL path : urls) {
            buffer.append(path).append("\n");
            if (!this.verbose) continue;
            this.getLog().info((CharSequence)("add " + path));
        }
        this.writeFile(bundleOut, buffer.toString(), this.encoding);
    }

    protected I18nArtifact[] detectI18nArtifacts() throws IOException, DependencyTreeBuilderException {
        I18nArtifact i18nArtifact;
        HashMap<Artifact, I18nArtifact> dico = new HashMap<Artifact, I18nArtifact>();
        for (Object o : this.project.getArtifacts()) {
            i18nArtifact = new I18nArtifact((Artifact)o);
            if (i18nArtifact.detectBundles()) {
                if (!this.silent) {
                    this.getLog().info((CharSequence)("detected i18n artifact " + i18nArtifact));
                }
                dico.put(i18nArtifact.getArtifact(), i18nArtifact);
                continue;
            }
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)("reject artifact " + i18nArtifact));
        }
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("runtime");
        DependencyNode rootNode = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.factory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.collector);
        ArrayList artifacts = new ArrayList(dico.keySet());
        DependencyUtil.sortArtifacts((DependencyNode)rootNode, artifacts, (boolean)this.getLog().isDebugEnabled());
        Artifact projectArtifact = this.project.getArtifact();
        i18nArtifact = new I18nArtifact(projectArtifact, this.src.getParentFile());
        if (i18nArtifact.detectBundles()) {
            if (!this.silent) {
                this.getLog().info((CharSequence)("detected i18n artifact " + i18nArtifact));
            }
            artifacts.add(i18nArtifact.getArtifact());
            dico.put(i18nArtifact.getArtifact(), i18nArtifact);
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("reject artifact " + i18nArtifact));
        }
        I18nArtifact[] result = new I18nArtifact[artifacts.size()];
        int i = 0;
        for (Artifact artifact : artifacts) {
            result[i++] = (I18nArtifact)dico.get(artifact);
        }
        return result;
    }
}

