/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.i18n.plugin.AbstractI18nPlugin;
import org.nuiton.i18n.plugin.I18nLogger;
import org.nuiton.i18n.plugin.parser.Parser;
import org.nuiton.i18n.plugin.parser.ParserEvent;
import org.nuiton.i18n.plugin.parser.event.KeysModifier;
import org.nuiton.util.FileUpdater;
import org.nuiton.util.PluginHelper;
import org.nuiton.util.SourceEntry;

public abstract class AbstractI18nParser
extends AbstractI18nPlugin
implements Parser {
    protected boolean treateDefaultEntry;
    protected MySourceEntry[] entries;
    protected boolean showTouchedFiles;
    protected boolean safeMode;
    protected PluginHelper.SortedProperties result;
    protected PluginHelper.SortedProperties oldParser;
    protected PluginHelper.SortedProperties oldLanguage;
    protected int fileTreated = 0;
    protected long t0;
    protected boolean touchFile;
    protected List<File> treadedFiles;

    protected abstract String getOutGetter();

    protected abstract String getKeyModifierStart();

    protected abstract String getKeyModifierEnd();

    protected abstract String[] getDefaultIncludes();

    protected abstract String[] getDefaultExcludes();

    protected abstract File getDefaultBasedir();

    public abstract FileUpdater newFileUpdater(SourceEntry var1);

    @Override
    public void init() {
        super.init();
        this.t0 = System.nanoTime();
        this.result = new PluginHelper.SortedProperties(this.encoding);
        this.oldParser = new PluginHelper.SortedProperties(this.encoding);
        this.oldLanguage = new PluginHelper.SortedProperties(this.encoding);
        this.out.mkdirs();
        if (this.keysModifier) {
            this.addParserEvent(KeysModifier.getInstance(this.getKeyModifierStart(), this.getKeyModifierEnd(), this.encoding));
        }
        this.treadedFiles = new ArrayList<File>();
        if (!this.silent && this.verbose) {
            this.showTouchedFiles = true;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        if (this.entries == null || this.entries.length == 0 && !this.treateDefaultEntry) {
            return;
        }
        if (!this.silent && this.safeMode) {
            this.getLog().info((CharSequence)"config - safeMode is on (could be slower).");
        }
        if (!this.silent && this.strictMode) {
            this.getLog().info((CharSequence)"config - strictMode is on (all files will be parsed).");
        }
        try {
            File oldParserFile = this.getGetterFile(this.out, this.getOutGetter(), true);
            File saveFile = this.getGetterFileBackup(this.out, this.getOutGetter());
            this.oldParser.load(oldParserFile);
            this.copyFile(oldParserFile, saveFile);
            File oldLanguageFile = this.getI18nFile(this.src, this.artifactId, this.locales[0], true);
            this.oldLanguage.load(oldLanguageFile);
            this.parse();
            saveFile.delete();
            int i = this.treadedFiles.size();
            if (this.fileTreated == 0) {
                if (!this.silent) {
                    this.getLog().info((CharSequence)"Nothing to generate - all files are up to date.");
                }
            } else {
                if (!this.silent) {
                    this.getLog().info((CharSequence)this.getVerboseLog().getLogEntry("parsing is done. [treated file(s) : " + i + '/' + this.fileTreated + "]", this.fileTreated, 0L, this.t0));
                }
                this.addGetter();
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error code parsing ", (Throwable)e);
            throw new MojoFailureException("Error code parsing");
        }
    }

    @Override
    public void parse() throws IOException {
        if (this.treateDefaultEntry) {
            this.addDefaultEntry();
        }
        long t00 = System.nanoTime();
        for (MySourceEntry entry : this.entries) {
            I18nLogger vLog = this.getVerboseLog();
            vLog.setEntry(entry);
            boolean skip = entry.init(this);
            if (skip) {
                if (this.silent || !this.verbose) continue;
                this.getLog().info((CharSequence)("skip - " + entry.getSkipMessage()));
                continue;
            }
            long t000 = System.nanoTime();
            int nbFiles = entry.getFiles().length;
            if (!this.silent && this.verbose) {
                vLog.infoEntry("start", vLog.getLogEntry("[incoming file(s) : " + entry.getFoudFiles() + "]", 0, 0L, 0L));
            }
            this.parseEntry(entry);
            if (!this.silent && this.verbose) {
                for (String skipFile : entry.getSkipFiles()) {
                    vLog.setFile(new File(entry.getBasedir(), skipFile));
                    vLog.infoFile("skip", null);
                }
            }
            this.fileTreated += nbFiles;
            if (!this.silent && this.verbose) {
                vLog.infoEntry("end", vLog.getLogEntry("[treated file(s)  : " + nbFiles + "]", nbFiles, t000, t00));
            }
            t00 = System.nanoTime();
        }
    }

    protected void addDefaultEntry() {
        ArrayList<MySourceEntry> list = this.entries == null || this.entries.length == 0 ? new ArrayList<MySourceEntry>() : new ArrayList<MySourceEntry>(Arrays.asList(this.entries));
        list.add(new MySourceEntry());
        this.entries = list.toArray(new MySourceEntry[list.size()]);
    }

    protected final void parseEntry(SourceEntry entry) throws IOException {
        long t00 = System.nanoTime();
        String[] files = entry.getFiles();
        int beforeEntryResultSize = this.result.size();
        int max = files.length;
        for (int i = 0; i < max; ++i) {
            String file1 = files[i];
            long t000 = System.nanoTime();
            String fileName = entry.getBasedir().getAbsolutePath() + File.separator + file1;
            File file = new File(fileName);
            for (ParserEvent event : this.events) {
                event.eventChangeFile(file);
            }
            I18nLogger vLog = this.getVerboseLog();
            vLog.setFile(file);
            this.touchFile = false;
            int size = this.result.size();
            if (!this.silent && this.verbose) {
                vLog.infoFile("parse", null);
            }
            this.parseFile(file);
            if (this.safeMode && size != this.result.size()) {
                this.saveGetterFile();
            }
            if (this.touchFile) {
                if (this.showTouchedFiles) {
                    vLog.infoFile("touch", null);
                }
                this.treadedFiles.add(file);
                if (this.getLog().isDebugEnabled()) {
                    vLog.debug(vLog.getLogEntry(fileName, i, t000, t00));
                }
            }
            for (ParserEvent event : this.events) {
                event.eventNextFile(file);
            }
        }
        if (!this.safeMode && beforeEntryResultSize < this.result.size()) {
            this.saveGetterFile();
        }
    }

    protected void saveGetterFile() throws IOException {
        File getterFile = this.getGetterFile(this.out, this.getOutGetter(), false);
        this.result.store(getterFile);
    }

    public static class MySourceEntry
    extends SourceEntry {
        public boolean init(AbstractI18nParser mojo) {
            boolean todo;
            if (!this.useForGoal(mojo.getClass().getSimpleName())) {
                this.skipMessage = "exclude for this goal.";
                return true;
            }
            String[] filesForEntry = this.getFilesForEntry(mojo);
            if (filesForEntry.length == 0) {
                this.skipMessage = "no file found.";
                return true;
            }
            this.setUpdater(mojo.newFileUpdater(this));
            if (mojo.strictMode || this.updater == null) {
                this.skipFiles = new String[0];
                this.files = filesForEntry;
                return false;
            }
            ArrayList<String> listFiles = new ArrayList<String>();
            ArrayList<String> listSkipFiles = new ArrayList<String>();
            for (String foundFile : filesForEntry) {
                File file = new File(this.getBasedir(), foundFile);
                if (this.isFileUptodate(file)) {
                    listSkipFiles.add(foundFile);
                    continue;
                }
                listFiles.add(foundFile);
            }
            boolean bl = todo = !listFiles.isEmpty();
            if (!todo) {
                this.skipMessage = "all files are up to date.";
                this.skipFiles = listSkipFiles.toArray(new String[listSkipFiles.size()]);
                this.files = new String[0];
                return true;
            }
            this.skipFiles = listSkipFiles.toArray(new String[listSkipFiles.size()]);
            this.files = listFiles.toArray(new String[listFiles.size()]);
            return false;
        }

        protected String[] getFilesForEntry(AbstractI18nParser mojo) {
            return this.getIncludedFiles(mojo.getDefaultBasedir(), mojo.getDefaultIncludes(), mojo.getDefaultExcludes());
        }
    }
}

