/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.i18n.plugin.AbstractI18nMojo;
import org.nuiton.i18n.plugin.parser.java.Java8BaseVisitor;
import org.nuiton.i18n.plugin.parser.java.Java8Lexer;
import org.nuiton.i18n.plugin.parser.java.Java8Parser;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="generateI18nEnumHelper", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateI18nEnumHelperMojo
extends AbstractI18nMojo {
    @Parameter(property="i18n.packageName")
    private String packageName;
    @Parameter(property="i18n.className", defaultValue="I18nEnumHelper", required=true)
    private String className;
    @Parameter(property="i18n.outputdirectory", defaultValue="${basedir}/target/generated-sources/java", required=true)
    private File outputdirectory;
    @Parameter(required=true)
    private List<EnumerationSet> enumerationSets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        if (this.packageName == null) {
            this.packageName = this.getProject().getGroupId() + "." + this.getProject().getArtifactId().replaceAll("-", ".");
        }
        File directory = PluginHelper.getFile((File)this.outputdirectory, (String[])this.packageName.trim().split("\\."));
        File file = new File(directory, this.className + ".java");
        Files.createParentDirs((File)file);
        this.getLog().info((CharSequence)("Will generate to " + file));
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        try {
            writer.write("// Generated by " + ((Object)((Object)this)).getClass().getName() + " at " + new Date() + "\n");
            writer.write("package " + this.packageName + ";\n");
            writer.write("\n");
            writer.write("import java.util.Locale;\n");
            writer.write("\n");
            writer.write("import static org.nuiton.i18n.I18n.l;\n");
            writer.write("import static org.nuiton.i18n.I18n.n;\n");
            writer.write("import static org.nuiton.i18n.I18n.t;\n");
            writer.write("\n");
            writer.write("\n");
            writer.write("public class " + this.className + " {\n");
            writer.write("\n");
            HashSet<String> names = new HashSet<String>();
            for (EnumerationSet enumerationSet : this.enumerationSets) {
                if (!names.add(enumerationSet.getName())) continue;
                String methodName = "get" + StringUtils.capitalise((String)enumerationSet.getName());
                writer.write("    public static <E extends Enum<E>> String " + methodName + "(E e) {\n");
                writer.write("        return t(" + methodName + "Key(e));\n");
                writer.write("    }\n");
                writer.write("\n");
                writer.write("    public static <E extends Enum<E>> String " + methodName + "(Locale locale, E e) {\n");
                writer.write("        return l(locale, " + methodName + "Key(e));\n");
                writer.write("    }\n");
                writer.write("\n");
                writer.write("    protected static <E extends Enum<E>> String " + methodName + "Key(E e) {\n");
                writer.write("        return " + enumerationSet.transformToMessage() + ";\n");
                writer.write("    }\n");
                writer.write("\n");
            }
            writer.write("    static {\n\n");
            for (EnumerationSet enumerationSet : this.enumerationSets) {
                for (String anEnumType : enumerationSet.getEnums()) {
                    int ordinal = 0;
                    String simpleName = anEnumType.substring(anEnumType.lastIndexOf(46) + 1);
                    for (String name : this.getEnumConstants(anEnumType)) {
                        writer.write("        n(\"" + enumerationSet.transformToKey(anEnumType, simpleName, name, ordinal++ + "") + "\");\n");
                    }
                }
            }
            writer.write("\n    }\n");
            writer.write("}\n");
            writer.close();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private Set<String> getEnumConstants(String anEnumType) throws ClassNotFoundException, IOException {
        TreeSet<String> result;
        block4: {
            this.getLog().info((CharSequence)("Scan enum: " + anEnumType));
            result = new TreeSet<String>();
            try {
                Class<?> aClass = Class.forName(anEnumType);
                if (!aClass.isEnum()) {
                    throw new IllegalStateException("Type " + aClass.getName() + " is not an enum.");
                }
                for (Object o : aClass.getEnumConstants()) {
                    result.add(((Enum)o).name());
                }
            }
            catch (ClassNotFoundException e) {
                File basedir = new File(new File(new File(this.getProject().getBasedir(), "src"), "main"), "java");
                File file = PluginHelper.getFile((File)basedir, (String[])anEnumType.trim().split("\\."));
                File javaFile = new File(file.getParentFile(), file.getName() + ".java");
                if (!javaFile.exists()) break block4;
                String content = FileUtils.readFileToString((File)javaFile, (String)"UTF-8");
                CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)new Java8Lexer((CharStream)new ANTLRInputStream(content)));
                Java8Parser parser = new Java8Parser((TokenStream)tokenStream);
                ((ParserATNSimulator)parser.getInterpreter()).enable_global_context_dfa = true;
                JavaParserVisitor visitor = new JavaParserVisitor(javaFile);
                parser.compilationUnit().accept(visitor);
                Set<String> names = visitor.getNames();
                result.addAll(names);
            }
        }
        return result;
    }

    public static class EnumerationSet {
        private String name;
        private String pattern;
        private List<String> enums;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public List<String> getEnums() {
            return this.enums;
        }

        public void setEnums(List<String> enums) {
            this.enums = enums;
        }

        public String transformToKey(String className, String simpleName, String name, String ordinal) {
            String result = this.pattern;
            result = result.replace("@CLASS_NAME@", className);
            result = result.replace("@CLASS_SIMPLE_NAME@", simpleName);
            result = result.replace("@NAME@", name);
            result = result.replace("@ORDINAL@", ordinal);
            return result;
        }

        public String transformToMessage() {
            String result = "";
            StringTokenizer stringTokenizer = new StringTokenizer(this.pattern, "@");
            block12: while (stringTokenizer.hasMoreTokens()) {
                String token;
                if (!result.isEmpty()) {
                    result = result + " + ";
                }
                switch (token = stringTokenizer.nextToken()) {
                    case "CLASS_SIMPLE_NAME": {
                        result = result + "e.getClass().getSimpleName()";
                        continue block12;
                    }
                    case "CLASS_NAME": {
                        result = result + "e.getClass().getName()";
                        continue block12;
                    }
                    case "NAME": {
                        result = result + "e.name()";
                        continue block12;
                    }
                    case "ORDINAL": {
                        result = result + "e.ordinal()";
                        continue block12;
                    }
                }
                result = result + "\"" + token + "\"";
            }
            if (result.endsWith("+")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
    }

    protected class JavaParserVisitor
    extends Java8BaseVisitor<Void> {
        protected final Set<String> names;
        protected final File file;

        private JavaParserVisitor(File file) {
            this.file = file;
            this.names = new LinkedHashSet<String>();
        }

        public Set<String> getNames() {
            return this.names;
        }

        @Override
        public Void visitEnumConstant(Java8Parser.EnumConstantContext ctx) {
            String text = ctx.getChild(0).getText();
            this.names.add(text);
            return (Void)super.visitEnumConstant(ctx);
        }
    }
}

