/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.AbstractI18nGenerateMojo;
import org.nuiton.i18n.plugin.I18nUtil;
import org.nuiton.io.SortedProperties;

@Mojo(name="gen", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
@Execute(goal="get")
public class GenerateMojo
extends AbstractI18nGenerateMojo {
    @Parameter(property="i18n.src", defaultValue="${basedir}/src/main/resources/i18n", required=true)
    protected File src;
    @Parameter(property="i18n.genSrc", defaultValue="true")
    protected boolean genSrc;
    @Parameter(property="i18n.strictMode", defaultValue="false")
    protected boolean strictMode;
    @Parameter(property="i18n.checkBundle", defaultValue="true", required=true)
    protected boolean checkBundle;
    @Parameter(property="i18n.showEmpty", defaultValue="false", required=true)
    protected boolean showEmpty;
    @Parameter(property="i18n.keepBackup", defaultValue="false")
    protected boolean keepBackup;
    @Parameter(property="i18n.keepGetters", defaultValue="false")
    protected boolean keepGetters;

    protected boolean checkSkip() {
        boolean result = true;
        if (!this.needGeneration()) {
            this.getLog().info((CharSequence)"No getter detected - all files are up to date.");
            result = false;
        }
        return result;
    }

    protected void doAction() throws Exception {
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - src basedir : " + this.src.getAbsolutePath()));
            this.getLog().info((CharSequence)("config - out basedir : " + this.out.getAbsolutePath()));
            this.getLog().info((CharSequence)("config - locales     : " + Arrays.toString(this.locales)));
        }
        for (Locale locale : this.locales) {
            if (!this.silent) {
                this.getLog().info((CharSequence)("prepare bundle for locale " + locale));
            }
            File bundleSrc = I18nUtil.getI18nFile(this.src, this.artifactId, locale, false);
            File bundleOut = I18nUtil.getI18nFile(this.out, this.artifactId, locale, false);
            File bundleGetterOut = I18nUtil.getI18nFile(this.out, this.artifactId + "-fromGetters", locale, false);
            SortedProperties propertiesSrc = new SortedProperties(this.encoding);
            if (bundleSrc.exists()) {
                propertiesSrc.load(bundleSrc);
            }
            SortedProperties propertiesOut = new SortedProperties(this.encoding);
            if (!this.strictMode) {
                propertiesOut.putAll((Map)propertiesSrc);
            }
            propertiesOut.load(bundleGetterOut);
            for (Object key : propertiesOut.keySet()) {
                Object oldKey = propertiesOut.get(key);
                Object value = propertiesSrc.get(oldKey);
                if (!key.equals(oldKey) && value == null) {
                    value = propertiesSrc.get(key);
                }
                if (value != null) {
                    propertiesOut.put(key, value);
                    continue;
                }
                propertiesOut.put(key, (Object)"");
            }
            propertiesOut.store(bundleOut);
            if (this.genSrc && this.keepBackup) {
                this.backupFile(bundleSrc);
            }
            if (!this.silent) {
                this.getLog().info((CharSequence)("merge bundle " + locale + " to out"));
            }
            if (this.checkBundle) {
                this.checkBundle(locale, (Properties)propertiesOut, this.showEmpty, null);
            }
            if (this.genSrc) {
                propertiesOut.store(bundleSrc);
                if (!this.silent) {
                    this.getLog().info((CharSequence)("copy bundle " + locale + " to src"));
                }
            }
            if (this.keepGetters) continue;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will delete getter " + bundleGetterOut));
            }
            this.deleteFile(bundleGetterOut);
        }
    }
}

