/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelPackage;

public class JavaEnumerationTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(JavaEnumerationTransformer.class);

    public void transformFromEnumeration(ObjectModelEnumeration input) {
        if (!this.canGenerate(input)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip generation for " + input.getQualifiedName()));
            }
            return;
        }
        ObjectModelEnumeration output = this.createEnumeration(input.getName(), input.getPackageName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        Collection literals = input.getLiterals();
        for (String literal : literals) {
            this.addLiteral(output, literal);
        }
    }

    protected boolean canGenerate(ObjectModelEnumeration input) {
        boolean b;
        ObjectModelPackage aPackage = this.getPackage((ObjectModelClassifier)input);
        boolean bl = b = !EugeneCoreTagValues.isSkip((ObjectModelClassifier)input, (ObjectModelPackage)aPackage);
        if (b) {
            b = !this.getResourcesHelper().isJavaFileInClassPath(input.getQualifiedName());
        }
        return b;
    }
}

