/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.impl.PollUrlService;
import org.chorem.pollen.services.impl.PollVoteCountingService;
import org.nuiton.i18n.I18n;

public class PollFeedService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(PollFeedService.class);

    public boolean isFeedExists(Poll poll) {
        File file = this.getFeedLocation(poll);
        return file.exists();
    }

    public File getFeedLocation(Poll poll) {
        File feedDirectory = this.getConfiguration().getFeedDirectory();
        String filename = poll.getPollId() + ".xml";
        File result = new File(feedDirectory, filename);
        return result;
    }

    public String getFeed(Poll poll) {
        File feedDirectory = this.getConfiguration().getFeedDirectory();
        String filename = poll.getPollId() + ".xml";
        File feedFile = new File(feedDirectory, filename);
        try {
            String result = FileUtils.readFileToString((File)feedFile, (Charset)Charsets.UTF_8);
            return result;
        }
        catch (IOException e) {
            throw new PollenTechnicalException("Could not read feed file", (Throwable)e);
        }
    }

    public void onPollCreated(Poll poll) {
        String title = I18n._((String)"pollen.feed.createPollContent", (Object[])new Object[]{poll.getCreator().getVotingId()});
        String content = I18n._((String)"pollen.feed.createPollContent", (Object[])new Object[]{poll.getDescription()});
        this.addFeedEntry(poll, title, content);
    }

    public void onCommentAdded(Poll poll, Comment comment) {
        String title = I18n._((String)"pollen.feed.addCommentTitle", (Object[])new Object[]{comment.getAuthor()});
        String content = I18n._((String)"pollen.feed.addCommentContent", (Object[])new Object[]{comment.getText()});
        this.addFeedEntry(poll, title, content);
    }

    public void onCommentDeleted(Poll poll, Comment comment, String reason) {
        String title = I18n._((String)"pollen.feed.deleteCommentTitle", (Object[])new Object[]{comment.getAuthor(), reason});
        String content = I18n._((String)"pollen.feed.deleteCommentContent", (Object[])new Object[]{comment.getText()});
        this.addFeedEntry(poll, title, content);
    }

    public void onVoteAdded(Poll poll, Vote vote) {
        PollVoteCountingService service = this.newService(PollVoteCountingService.class);
        String pollResult = service.getResultsAsString(poll);
        String userId = vote.isAnonymous() ? I18n._((String)"pollen.common.anonymous", (Object[])new Object[0]) : vote.getPollAccount().getVotingId();
        String title = I18n._((String)"pollen.feed.addVoteTitle", (Object[])new Object[]{userId});
        String content = I18n._((String)"pollen.feed.addVoteContent", (Object[])new Object[]{pollResult});
        this.addFeedEntry(poll, title, content);
    }

    public void onVoteUpdated(Poll poll, Vote vote) {
        PollVoteCountingService service = this.newService(PollVoteCountingService.class);
        String pollResult = service.getResultsAsString(poll);
        String userId = vote.isAnonymous() ? I18n._((String)"pollen.common.anonymous", (Object[])new Object[0]) : vote.getPollAccount().getVotingId();
        String title = I18n._((String)"pollen.feed.updateVoteTitle", (Object[])new Object[]{userId});
        String content = I18n._((String)"pollen.feed.updateVoteContent", (Object[])new Object[]{pollResult});
        this.addFeedEntry(poll, title, content);
    }

    public void onVoteDeleted(Poll poll, Vote vote, PollAccount voteAccount, String reason) {
        PollVoteCountingService service = this.newService(PollVoteCountingService.class);
        String pollResult = service.getResultsAsString(poll);
        String userId = vote.isAnonymous() ? I18n._((String)"pollen.common.anonymous", (Object[])new Object[0]) : voteAccount.getVotingId();
        String title = I18n._((String)"pollen.feed.deleteVoteTitle", (Object[])new Object[]{userId, reason});
        String content = I18n._((String)"pollen.feed.deleteVoteContent", (Object[])new Object[]{pollResult});
        this.addFeedEntry(poll, title, content);
    }

    public void onChoiceAdded(Poll poll, Choice choice) {
        String title = I18n._((String)"pollen.feed.addChoiceTitle", (Object[])new Object[]{choice.getName()});
        String content = I18n._((String)"pollen.feed.addChoiceContent", (Object[])new Object[]{choice.getDescription()});
        this.addFeedEntry(poll, title, content);
    }

    public void deleteFeed(Poll poll) {
        File feedLocation = this.getFeedLocation(poll);
        if (feedLocation.exists()) {
            boolean wasDeleted = feedLocation.delete();
            if (!wasDeleted) {
                throw new PollenTechnicalException("Could not delete feed");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Feed deleted: " + feedLocation.getAbsolutePath()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFeedEntry(Poll poll, String title, String content) {
        File file = this.getFeedLocation(poll);
        PollUrlService urlService = this.newService(PollUrlService.class);
        PollUrl voteUrl = urlService.getPollVoteUrl(poll);
        try {
            SyndFeed feed = this.getFeed(file, poll);
            ArrayList entries = Lists.newArrayList((Iterable)feed.getEntries());
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(title);
            entry.setLink(voteUrl.getUrl());
            entry.setPublishedDate(this.serviceContext.getCurrentTime());
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/plain");
            description.setValue(content);
            entry.setDescription((SyndContent)description);
            entries.add(entry);
            feed.setEntries((List)entries);
            FileWriter writer = new FileWriter(file);
            try {
                SyndFeedOutput output = new SyndFeedOutput();
                output.output(feed, (Writer)writer);
                ((Writer)writer).close();
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Feed updated: " + file.getAbsolutePath()));
            }
        }
        catch (PollenTechnicalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PollenTechnicalException("Could not feed feed", (Throwable)e);
        }
    }

    protected SyndFeed getFeed(File file, Poll poll) throws IOException, FeedException {
        SyndFeed feed;
        SyndFeedInput input = new SyndFeedInput();
        if (!file.exists()) {
            feed = this.createFeed(file, poll);
        } else {
            try {
                feed = input.build((Reader)new XmlReader(file));
            }
            catch (FeedException e) {
                feed = this.createFeed(file, poll);
            }
        }
        return feed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SyndFeed createFeed(File file, Poll poll) throws IOException, FeedException {
        String title = I18n.l_((Locale)this.getLocale(), (String)"pollen.feed.pollTitle", (Object[])new Object[]{poll.getTitle()});
        String description = I18n.l_((Locale)this.getLocale(), (String)"pollen.feed.pollDescription", (Object[])new Object[]{poll.getDescription()});
        PollUrlService urlService = this.newService(PollUrlService.class);
        PollUrl voteUrl = urlService.getPollVoteUrl(poll);
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("atom_1.0");
        feed.setTitle(title);
        feed.setLink(voteUrl.getUrl());
        feed.setDescription(description);
        FileWriter writer = new FileWriter(file);
        try {
            SyndFeedOutput output = new SyndFeedOutput();
            output.output((SyndFeed)feed, (Writer)writer);
            ((Writer)writer).close();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Feed created: " + file.getAbsolutePath()));
        }
        return feed;
    }
}

