/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PersonToListDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VoteToChoiceDAO;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.PollAccountNotFound;
import org.chorem.pollen.services.exceptions.VoteNotFoundException;
import org.chorem.pollen.services.impl.PollFeedService;
import org.chorem.pollen.services.impl.PreventRuleService;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;

public class VoteService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(VoteService.class);

    public Vote getVoteEditable(Poll poll, PollAccount accountEditable) {
        VoteToChoiceDAO voteToChoiceDAO;
        Vote result;
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)accountEditable);
        VoteDAO dao = (VoteDAO)this.getDAO(Vote.class);
        Vote voteLoaded = null;
        if (StringUtils.isNotBlank((CharSequence)accountEditable.getAccountId())) {
            try {
                voteLoaded = dao.findByPollAndAccountId(poll, accountEditable.getAccountId());
            }
            catch (TopiaException e) {
                throw new PollenTechnicalException((Throwable)e);
            }
        }
        if (voteLoaded != null) {
            result = (Vote)this.newInstance(dao);
            PollenBinderHelper.simpleCopy((TopiaEntity)voteLoaded, (TopiaEntity)result, (boolean)true);
            result.setPollAccount(accountEditable);
            voteToChoiceDAO = (VoteToChoiceDAO)this.getDAO(VoteToChoice.class);
            ArrayList voteToChoices = Lists.newArrayList();
            List choices = poll.getChoice();
            for (int i = 0; i < choices.size(); ++i) {
                Choice choice = (Choice)choices.get(i);
                VoteToChoice voteToChoice = (VoteToChoice)this.newInstance(voteToChoiceDAO);
                voteToChoice.setChoice(choice);
                VoteToChoice voteToChoiceLoaded = voteLoaded.getChoiceVoteToChoice(choice);
                if (voteToChoiceLoaded != null) {
                    voteToChoice.setVoteValue(voteToChoiceLoaded.getVoteValue());
                }
                voteToChoices.add(i, voteToChoice);
            }
            result.setChoiceVoteToChoice((List)voteToChoices);
        } else {
            result = (Vote)this.newInstance(dao);
            result.setPollAccount(accountEditable);
            result.setWeight(1.0);
            voteToChoiceDAO = (VoteToChoiceDAO)this.getDAO(VoteToChoice.class);
            for (Choice choice : poll.getChoice()) {
                VoteToChoice element = (VoteToChoice)this.newInstance(voteToChoiceDAO);
                element.setChoice(choice);
                result.addChoiceVoteToChoice(element);
            }
        }
        if (!poll.isPollFree() && accountEditable.getTopiaId() != null) {
            PersonToListDAO personToListDAO = (PersonToListDAO)this.getDAO(PersonToList.class);
            PersonToList personToList = personToListDAO.findByPollAndAccount(poll, accountEditable);
            result.setWeight(personToList.getWeight());
        }
        if (poll.isAnonymous()) {
            result.setAnonymous(true);
        }
        return result;
    }

    public Vote createVote(Poll poll, Vote vote) throws PollAccountNotFound {
        PollAccount pollAccountLoaded;
        VoteDAO voteDAO = (VoteDAO)this.getDAO(Vote.class);
        Vote result = (Vote)this.create(voteDAO);
        result.setWeight(vote.getWeight());
        result.setAnonymous(vote.isAnonymous() || poll.isAnonymous());
        PollAccount pollAccount = vote.getPollAccount();
        String pollAccountId = pollAccount.getTopiaId();
        if (pollAccountId == null) {
            PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
            pollAccountLoaded = (PollAccount)this.createWithProperties(pollAccountDAO, "accountId", this.serviceContext.generateId());
        } else {
            pollAccountLoaded = this.getEntityById(PollAccount.class, pollAccountId);
        }
        pollAccountLoaded.setVotingId(pollAccount.getVotingId());
        pollAccountLoaded.setEmail(pollAccount.getEmail());
        UserAccount userAccount = pollAccount.getUserAccount();
        if (userAccount != null) {
            UserAccount userAccountLoaded = this.getEntityById(UserAccount.class, userAccount.getTopiaId());
            pollAccountLoaded.setUserAccount(userAccountLoaded);
        }
        result.setPollAccount(pollAccountLoaded);
        for (VoteToChoice input : vote.getChoiceVoteToChoice()) {
            Integer value = input.getVoteValue();
            if (value == null) continue;
            this.createVoteToChoice(result, input);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entity created: " + result.getTopiaId()));
        }
        Poll pollToUpdate = this.getEntityById(Poll.class, poll.getTopiaId());
        pollToUpdate.addVote(result);
        if (!poll.isPollFree()) {
            PersonToList personToList = pollToUpdate.getPersonToListByVote(result);
            personToList.setHasVoted(true);
        }
        PollFeedService pollFeedService = this.newService(PollFeedService.class);
        pollFeedService.onVoteAdded(pollToUpdate, result);
        this.commitTransaction("Could not create vote");
        PreventRuleService preventRuleService = this.newService(PreventRuleService.class);
        preventRuleService.onVoteAdded(poll);
        return result;
    }

    public Vote updateVote(Poll poll, Vote vote) throws VoteNotFoundException {
        Vote result = this.getEntityById(Vote.class, vote.getTopiaId());
        if (result == null) {
            throw new VoteNotFoundException();
        }
        PollAccount voteAccount = vote.getPollAccount();
        PollAccount pollAccountEntity = result.getPollAccount();
        pollAccountEntity.setVotingId(voteAccount.getVotingId());
        pollAccountEntity.setEmail(voteAccount.getEmail());
        pollAccountEntity.setUserAccount(voteAccount.getUserAccount());
        result.setAnonymous(vote.isAnonymous() || poll.isAnonymous());
        VoteToChoiceDAO voteToChoiceDao = (VoteToChoiceDAO)this.getDAO(VoteToChoice.class);
        for (VoteToChoice input : vote.getChoiceVoteToChoice()) {
            Integer value = input.getVoteValue();
            VoteToChoice voteToChoiceEntity = result.getChoiceVoteToChoice(input.getChoice());
            if (value != null) {
                if (voteToChoiceEntity != null) {
                    voteToChoiceEntity.setVoteValue(value);
                    continue;
                }
                this.createVoteToChoice(result, input);
                continue;
            }
            if (voteToChoiceEntity == null) continue;
            result.removeChoiceVoteToChoice(voteToChoiceEntity);
            this.delete(voteToChoiceDao, voteToChoiceEntity);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entity updated: " + result.getTopiaId()));
        }
        PollFeedService pollFeedService = this.newService(PollFeedService.class);
        pollFeedService.onVoteUpdated(poll, result);
        this.commitTransaction("Could not update vote");
        return result;
    }

    public void deleteVote(Poll poll, String voteId, String reason) throws VoteNotFoundException {
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)voteId);
        Vote entityToDelete = this.getEntityById(Vote.class, voteId);
        if (entityToDelete == null) {
            throw new VoteNotFoundException();
        }
        VoteDAO dao = (VoteDAO)this.getDAO(Vote.class);
        VoteToChoiceDAO voteToChoiceDao = (VoteToChoiceDAO)this.getDAO(VoteToChoice.class);
        ImmutableList voteToChoices = ImmutableList.copyOf((Collection)entityToDelete.getChoiceVoteToChoice());
        for (VoteToChoice voteToChoice : voteToChoices) {
            entityToDelete.removeChoiceVoteToChoice(voteToChoice);
            this.delete(voteToChoiceDao, voteToChoice);
        }
        PollAccount voteAccount = entityToDelete.getPollAccount();
        if (poll.isPollFree()) {
            if (!voteAccount.equals(poll.getCreator())) {
                PollAccountDAO accountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
                this.delete(accountDAO, voteAccount);
            }
        } else {
            PersonToList personToList = poll.getPersonToListByVote(entityToDelete);
            personToList.setHasVoted(false);
        }
        poll.removeVote(entityToDelete);
        this.delete(dao, entityToDelete);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entity deleted: " + voteId));
        }
        PollFeedService pollFeedService = this.newService(PollFeedService.class);
        pollFeedService.onVoteDeleted(poll, entityToDelete, voteAccount, reason);
        this.commitTransaction("Could not delete vote");
    }

    public List<Vote> getAllVotes(Poll poll) {
        try {
            VoteDAO dao = (VoteDAO)this.getDAO(Vote.class);
            List results = dao.findAllVotes(poll);
            return results;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain votes", (Throwable)e);
        }
    }

    public List<Vote> getVotesByPoll(Poll poll, TopiaPagerBean pager) {
        try {
            VoteDAO dao = (VoteDAO)this.getDAO(Vote.class);
            List results = dao.findAllVotesByPoll(poll, pager);
            return results;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain votes", (Throwable)e);
        }
    }

    public boolean isVotingIdFree(Poll poll, String pollAccountId, String votingId) {
        try {
            VoteDAO dao = (VoteDAO)this.getDAO(Vote.class);
            Vote existingVote = dao.findVoteByPollAndVotingId(poll, votingId);
            boolean result = existingVote == null ? true : existingVote.getPollAccount().getTopiaId().equals(pollAccountId);
            return result;
        }
        catch (Exception e) {
            throw new PollenTechnicalException("Unable test vote existing for account with votingId = " + votingId + " and poll with uid = " + poll.getPollId(), (Throwable)e);
        }
    }

    protected VoteToChoice createVoteToChoice(Vote vote, VoteToChoice source) {
        VoteToChoiceDAO voteToChoiceDao = (VoteToChoiceDAO)this.getDAO(VoteToChoice.class);
        VoteToChoice result = (VoteToChoice)this.create(voteToChoiceDao);
        String choiceId = source.getChoice().getTopiaId();
        Choice choiceLoaded = this.getEntityById(Choice.class, choiceId);
        result.setChoice(choiceLoaded);
        result.setVote(vote);
        result.setVoteValue(source.getVoteValue());
        vote.addChoiceVoteToChoice(result);
        return result;
    }
}

