/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.bean;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class PollUri
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String pollId;
    protected String accountId;

    public static PollUri newPollUri(String uri) {
        PollUri result = new PollUri();
        String[] split = uri.split(":", 2);
        if (split.length > 0) {
            result.setPollId(split[0]);
            if (split.length > 1) {
                result.setAccountId(split[1]);
            }
        }
        return result;
    }

    public static PollUri newPollUri(String pollId, String accountId) {
        Preconditions.checkNotNull((Object)pollId);
        PollUri result = new PollUri();
        result.pollId = pollId;
        result.accountId = accountId;
        return result;
    }

    private PollUri() {
    }

    public String getPollId() {
        return this.pollId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean isPollIdNotBlank() {
        return StringUtils.isNotBlank((CharSequence)this.pollId);
    }

    public boolean isAccountIdNotBlank() {
        return StringUtils.isNotBlank((CharSequence)this.accountId);
    }

    public String getUri() {
        String result = this.pollId;
        if (StringUtils.isNotEmpty((CharSequence)this.accountId)) {
            result = result + ":" + this.accountId;
        }
        return result;
    }

    public String toString() {
        return this.getUri();
    }
}

