/*
 * #%L
 * Pollen :: Services
 * 
 * $Id: ChoiceHelper.java 3229 2012-04-02 17:30:25Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-services/src/main/java/org/chorem/pollen/bean/ChoiceHelper.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.bean;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.common.ChoiceType;

import java.util.Date;

/**
 * Used to manage all objects from {@link Choice} inheritance tree depends
 * on {@link ChoiceType}.
 * <p/>
 * Created: 30/03/12
 *
 * @author fdesbois <desbois@codelutin.com>
 */
public final class ChoiceHelper {
    
    private ChoiceHelper() {         
    }

    public static Object toValue(Choice choice, ChoiceType choiceType) {
        Object result;
        switch (choiceType) {
            case DATE:
                if (choice instanceof PollDateChoice) {
                    result = ((PollDateChoice)choice).getDate();
                } else {
                    result = new Date(Long.parseLong(choice.getName()));
                }
                break;
            case IMAGE:
                if (choice instanceof PollImageChoice) {
                    result = ((PollImageChoice)choice).getLocation();
                } else {
                    result = choice.getName();
                }
                break;
            case TEXT:
            default:
                result = choice.getName();
        }
        return result;
    }

    public static Function<Choice, Object> toValue(final ChoiceType type) {
        return new Function<Choice, Object>() {

            @Override
            public Object apply(Choice input) {
                return toValue(input, type);
            }
        };
    }

    public static Iterable<Object> toValues(Iterable<Choice> choices,
                                            ChoiceType choiceType) {
        return Iterables.transform(choices, toValue(choiceType));
    }

    public static String getValuePropertyName(ChoiceType choiceType) {
        String result;
        switch (choiceType) {
            case DATE:
                result = PollDateChoice.PROPERTY_DATE;
                break;
            case IMAGE:
                result = PollImageChoice.PROPERTY_LOCATION;
                break;
            case TEXT:
            default:
                result = Choice.PROPERTY_NAME;
        }
        return result;
    }
    
}
