/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.services.FavoriteListImport;
import org.chorem.pollen.services.PollenServicePredicates;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.FavoriteListImportException;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;
import org.nuiton.util.csv.Import;
import org.nuiton.util.csv.ImportModel;
import org.nuiton.util.csv.ImportRuntimeException;
import org.nuiton.util.csv.ImportableColumn;
import org.nuiton.util.csv.ModelBuilder;
import org.nuiton.util.csv.ValueParser;

public class FavoriteListImportCSV
extends PollenServiceSupport
implements FavoriteListImport {
    private static final Log log = LogFactory.getLog(FavoriteListImportCSV.class);
    private static final ValueParser<String> EMAIL_PARSER = new ValueParser<String>(){

        public String parse(String value) throws ParseException {
            if (value != null && !StringUtil.isEmail((String)value)) {
                throw new ParseException(I18n._((String)"pollen.error.email.invalid", (Object[])new Object[0]), 0);
            }
            return value;
        }
    };

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PollAccount> execute(String url) throws FavoriteListImportException {
        ArrayList results;
        FileReader reader = null;
        try {
            reader = new FileReader(new File(url));
            Import csvImport = Import.newImport((ImportModel)new FavoriteListImportModel(), (Reader)reader);
            results = Lists.newArrayList((Iterable)Iterables.filter((Iterable)csvImport, PollenServicePredicates.POLL_ACCOUNT_NOT_EMPTY));
            if (log.isInfoEnabled()) {
                log.info((Object)(results.size() + " comptes import\u00e9s."));
            }
        }
        catch (FileNotFoundException ex) {
            try {
                throw new PollenTechnicalException((Throwable)ex);
                catch (ImportRuntimeException ex2) {
                    if (!log.isDebugEnabled()) throw new FavoriteListImportException("CSV", ex2);
                    log.debug((Object)"Error during CSV import", (Throwable)ex2);
                    throw new FavoriteListImportException("CSV", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return results;
    }

    protected class FavoriteListImportModel
    implements ImportModel<PollAccount> {
        protected FavoriteListImportModel() {
        }

        public char getSeparator() {
            return ',';
        }

        public void pushCsvHeaderNames(List<String> headerNames) {
        }

        public PollAccount newEmptyInstance() {
            return (PollAccount)FavoriteListImportCSV.this.newInstance(FavoriteListImportCSV.this.getDAO(PollAccount.class));
        }

        public Iterable<ImportableColumn<PollAccount, Object>> getColumnsForImport() {
            ModelBuilder modelBuilder = new ModelBuilder();
            modelBuilder.newMandatoryColumn("votingId", "votingId");
            modelBuilder.newMandatoryColumn("email", "email", EMAIL_PARSER);
            return modelBuilder.getColumnsForImport();
        }
    }
}

