/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.services;

import java.util.List;
import java.util.Map;

import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.persistence.PollAccount;
import org.nuiton.topia.TopiaContext;

/**
 * Interface du service de gestion des comptes.
 *
 * @author kmorin
 * @version $Id: ServicePollAccount.java 2732 2009-08-18 12:26:50Z nrannou $
 */
public interface ServicePollAccount {

    /**
     * Creation d'un compte utilisateur.
     *
     * @param pollAccount le compte à creer
     * @return le topiaId du compte créé
     */
    public String createPollAccount(PollAccountDTO pollAccount);

    /**
     * Creation d'un compte utilisateur.
     *
     * @param votingId l'identifiant du votant
     * @param email l'email du votant
     * @param userId l'identifiant de l'utilisateur
     * @return le topiaId du compte créé
     */
    public PollAccount createPollAccount(String votingId, String email,
            String userId);

    /**
     * Creation des comptes utilisateur.
     *
     * @param pollAccounts les comptes à creer
     * @param transaction la transaction
     * @return les comptes créés
     */
    public List<PollAccount> createPollAccounts(
            List<PollAccountDTO> pollAccounts, TopiaContext transaction);

    /**
     * Suppression d'un compte.
     *
     * @param pollAccountId le compte a creer
     * @return true si le compte a été supprimer
     */
    public boolean deletePollAccount(String pollAccountId);

    /**
     * Modification d'un compte.
     *
     * @param pollAccount le compte a modifier
     * @return true si le compte à été modifier
     */
    public boolean updatePollAccount(PollAccountDTO pollAccount);

    /**
     * Récupération du compte à partir de son identifiant ToPIA.
     *
     * @param pollAccountId l'identifiant Topia du compte à rechercher
     * @return un compte
     */
    public PollAccountDTO findPollAccountById(String pollAccountId);

    /**
     * Récupération du compte à partir de son identifiant.
     *
     * @param pollAccountId l'identifiant du compte à rechercher
     * @return un compte
     */
    public PollAccountDTO findPollAccountByAccountId(String pollAccountId);

    /**
     * Récupération des comptes d'un utilisateur.
     *
     * @param userId l'identifiant de l'utilisateur
     * @return la liste des comptes de l'utilisateur
     */
    public List<PollAccountDTO> findPollAccountsByUser(String userId);

    /**
     * Recherche des comptes à partir d'un filtre.
     *
     * @param properties filtre sur les champs de la table pollAccount
     * @return les comptes
     */
    public List<PollAccountDTO> selectPollAccounts(
            Map<String, Object> properties);
}
