/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.services;

import java.util.List;
import java.util.Map;

import org.chorem.pollen.business.dto.CommentDTO;
import org.chorem.pollen.business.persistence.Comment;
import org.nuiton.topia.TopiaContext;

/**
 * Interface de gestion des commentaires d'un sondage
 *
 * @author enema
 * @version $Id: ServiceComment.java 2649 2009-07-15 16:30:23Z nrannou $
 */
public interface ServiceComment {

    /**
     * Création d'un commentaire
     *
     * @param comment le commentaire
     * @return identifiant du commentaire créé
     */
    public String createComment(CommentDTO comment);

    /**
     * Création des commentaires d'un sondage
     *
     * @param comments les dtos commentaires
     * @param pollId l'identifiant du sondage
     * @param transaction la transaction du sondage
     * @return les commentaires créés
     */
    public List<Comment> createComments(List<CommentDTO> comments,
            String pollId, TopiaContext transaction);

    /**
     * Mise à jour d'un commentaire
     *
     * @param comment le commentaire
     * @return true si le commentaire a été mise à jours
     */
    public boolean updateComment(CommentDTO comment);

    /**
     * Suppression d'un commentaire
     *
     * @param commentId identifiant du commentaire
     * @return true si le commentaire a été supprimé
     */
    public boolean deleteComment(String commentId);

    /**
     * Récupération d'un commentaire à partir de son identifiant
     *
     * @param commentId identifiant du commentaire
     * @return le commentaire
     */
    public CommentDTO findCommentById(String commentId);

    /**
     * Recherche des commentaires d'un sondage à partir d'un filtre
     *
     * @param properties filtre sur les champs de la table commentaire
     * @return les commentaires
     */
    public List<CommentDTO> selectComments(Map<String, Object> properties);
}