/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.services;

import org.chorem.pollen.business.dto.UserDTO;

/**
 * Interface du service d'authentification.
 *
 * @author kmorin
 * @version $Id: ServiceAuth.java 2737 2009-08-20 13:00:52Z nrannou $
 */
public interface ServiceAuth {

    /**
     * Identification d'un utilisateur. Vérification du couple login, password.
     *
     * @param login le login de l'utilisateur à identifié
     * @param password le password entré par l'utilisateur
     * @return vrai si l'utilisateur est identifié, false sinon
     */
    public boolean isLoginRight(String login, String password);

    /**
     * Identification d'un utilisateur. Récupération des informations de cet
     * utilisateur.
     *
     * @param login le login de l'utilisateur à identifié
     * @param password le password entré par l'utilisateur
     * @return l'utilisateur identifié par le login
     */
    public UserDTO getUser(String login, String password);
}