/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link VoteToChoice}.
 */
public abstract class VoteToChoiceAbstract extends TopiaEntityAbstract implements VoteToChoice {

    public Integer voteValue;

    public Vote vote;

    public Choice choice;

    /**
     * Constructeur de VoteToChoiceAbstract par défaut.
     */
    public VoteToChoiceAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(VoteToChoice.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(VoteToChoice.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "voteValue", Integer.class, voteValue);
        visitor.visit(this, "vote", Vote.class, vote);
        visitor.visit(this, "choice", Choice.class, choice);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see VoteToChoice#setVoteValue(Integer)
     */
    @Override
    public void setVoteValue(Integer value) {
        Integer _oldValue = this.voteValue;
        fireOnPreWrite("voteValue", _oldValue, value);
        this.voteValue = value;
        fireOnPostWrite("voteValue", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see VoteToChoice#getVoteValue()
     */
    @Override
    public Integer getVoteValue() {
        fireOnPreRead("voteValue", voteValue);
        Integer result = this.voteValue;
        fireOnPostRead("voteValue", voteValue);
        return result;
    }

    /**
     * @param value La valeur de l'attribut vote à positionner.
     */
    @Override
    public void setVote(Vote value) {
        Vote _oldValue = this.vote;
        fireOnPreWrite("vote", _oldValue, value);
        this.vote = value;
        fireOnPostWrite("vote", _oldValue, value);
    }

    /**
     * @return La valeur de l'attribut vote.
     */
    @Override
    public Vote getVote() {
        return vote;
    }

    /**
     * @param value La valeur de l'attribut choice à positionner.
     */
    @Override
    public void setChoice(Choice value) {
        Choice _oldValue = this.choice;
        fireOnPreWrite("choice", _oldValue, value);
        this.choice = value;
        fireOnPostWrite("choice", _oldValue, value);
    }

    /**
     * @return La valeur de l'attribut choice.
     */
    @Override
    public Choice getChoice() {
        return choice;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("voteValue", this.voteValue).
         toString();
        return result;
    }
        
} //VoteToChoiceAbstract
