/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.dto;

import java.io.Serializable;

/**
 * Classe DTO représentant une règle de notification.
 *
 * @author amine
 * @author rannou
 * @version $Id: PreventRuleDTO.java 2736 2009-08-19 15:48:01Z nrannou $
 */
public class PreventRuleDTO implements Serializable {

    private String id = "";

    private String pollId = "";

    private String scope = "";

    private int sensibility = 0;

    private boolean active = true;

    private boolean oneTime = false;

    private boolean repeated = false;

    private String method = "";

    public PreventRuleDTO() {
    }

    public PreventRuleDTO(String id) {
        this.id = id;
    }

    public PreventRuleDTO(String pollId, String scope, int sensibility,
            boolean repeated, String method) {
        super();
        this.scope = scope;
        this.sensibility = sensibility;
        this.repeated = repeated;
        this.method = method;
        this.pollId = pollId;
    }

    public PreventRuleDTO(String scope, int sensibility, boolean repeated,
            String method) {
        super();
        this.scope = scope;
        this.sensibility = sensibility;
        this.repeated = repeated;
        this.method = method;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPollId() {
        return pollId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int getSensibility() {
        return sensibility;
    }

    public void setSensibility(int sensibility) {
        this.sensibility = sensibility;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isOneTime() {
        return oneTime;
    }

    public void setOneTime(boolean oneTime) {
        this.oneTime = oneTime;
    }

    public boolean isRepeated() {
        return repeated;
    }

    public void setRepeated(boolean repeated) {
        this.repeated = repeated;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}