/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link VotingList}.
 */
public abstract class VotingListAbstract extends TopiaEntityAbstract implements VotingList {

    public String name;

    public double weight;

    public List<PersonToList> pollAccountPersonToList;

    public Poll poll;

    public Vote vote;

    /**
     * Constructeur de VotingListAbstract par défaut.
     */
    public VotingListAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(VotingList.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(VotingList.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "weight", double.class, weight);
        visitor.visit(this, "pollAccountPersonToList", java.util.List.class, PersonToList.class, pollAccountPersonToList);
        visitor.visit(this, "poll", Poll.class, poll);
        visitor.visit(this, "vote", Vote.class, vote);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        tmp.addAll(((TopiaContextImplementor)getTopiaContext())
            .getDAO(PersonToList.class)
            .findAllByProperties("votingList", this));

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see VotingList#setName(String)
     */
    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see VotingList#getName()
     */
    @Override
    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
    }

    /* (non-Javadoc)
     * @see VotingList#setWeight(double)
     */
    @Override
    public void setWeight(double value) {
        double _oldValue = this.weight;
        fireOnPreWrite("weight", _oldValue, value);
        this.weight = value;
        fireOnPostWrite("weight", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see VotingList#getWeight()
     */
    @Override
    public double getWeight() {
        fireOnPreRead("weight", weight);
        double result = this.weight;
        fireOnPostRead("weight", weight);
        return result;
    }

    /* (non-Javadoc)
     * @see VotingList#addPollAccountPersonToList(PersonToList)
     */
    @Override
    public void addPollAccountPersonToList(PersonToList value) {
        fireOnPreWrite("pollAccountPersonToList", null, value);
        if (this.pollAccountPersonToList == null) {
            this.pollAccountPersonToList = new ArrayList<PersonToList>();
        }
        value.setVotingList(this);
        this.pollAccountPersonToList.add(value);
        fireOnPostWrite("pollAccountPersonToList", this.pollAccountPersonToList.size(), null, value);
    }

    /* (non-Javadoc)
     * @see VotingList#getPollAccountByTopiaId(String)
     */
    @Override
    public PersonToList getPollAccountPersonToListByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(pollAccountPersonToList, topiaId);
    }

    /* (non-Javadoc)
     * @see VotingList#addAllPollAccountPersonToList(List<PersonToList>()
     */
    @Override
    public void addAllPollAccountPersonToList(List<PersonToList> values) {
        if (values == null) {
            return;
        }
        for (PersonToList item : values) {
            addPollAccountPersonToList(item);
        }
    }

    /* (non-Javadoc)
     * @see VotingList#setPollAccountPersonToList(List<PersonToList>()
     */
    @Override
    public void setPollAccountPersonToList(List<PersonToList> values) {
//        clearPollAccountPersonToList();
//        addAllPollAccountPersonToList(values);
// FIXME
        List<PersonToList> _oldValue = pollAccountPersonToList;
        fireOnPreWrite("pollAccountPersonToList", _oldValue, values);
        pollAccountPersonToList = values;
        fireOnPostWrite("pollAccountPersonToList", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see VotingList#removePollAccountPersonToList(PersonToList)
     */
    @Override
    public void removePollAccountPersonToList(PersonToList value) {
        fireOnPreWrite("pollAccountPersonToList", value, null);
        if ((this.pollAccountPersonToList == null) || (!this.pollAccountPersonToList.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setVotingList(null);
        fireOnPostWrite("pollAccountPersonToList", this.pollAccountPersonToList.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see VotingList#clearPollAccountPersonToList()
     */
    @Override
    public void clearPollAccountPersonToList() {
        if (this.pollAccountPersonToList == null) {
            return;
        }
        for (PersonToList item : this.pollAccountPersonToList) {
            item.setVotingList(null);
        }
        List<PersonToList> _oldValue = new ArrayList<PersonToList>(this.pollAccountPersonToList);
        fireOnPreWrite("pollAccountPersonToList", _oldValue, null);
        this.pollAccountPersonToList.clear();
        fireOnPostWrite("pollAccountPersonToList", _oldValue, null);
    }

    /* (non-Javadoc)
     * @see VotingList#getPollAccountPersonToList()
     */
    @Override
    public List<PersonToList> getPollAccountPersonToList() {
        return pollAccountPersonToList;
    }

    /* (non-Javadoc)
     * @see VotingList#getPollAccountPersonToList(PollAccount)
     */
    @Override
    public PersonToList getPollAccountPersonToList(PollAccount value) {
        if (value == null || pollAccountPersonToList == null) {
            return null;
        }
        for (PersonToList item : pollAccountPersonToList) {
            if (value.equals(item.getPollAccount())) {
                return item;
            }
        }
        return null;
    }

    /* (non-Javadoc)
     * @see VotingList#sizePollAccountPersonToList()
     */
    @Override
    public int sizePollAccountPersonToList() {
        if (pollAccountPersonToList == null) {
            return 0;
        }
        return pollAccountPersonToList.size();
    }

    /* (non-Javadoc)
     * @see VotingList#isPollAccountPersonToListEmpty()
     */
    @Override
    public boolean isPollAccountPersonToListEmpty() {
        int size = sizePollAccountPersonToList();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see VotingList#setPoll(Poll)
     */
    @Override
    public void setPoll(Poll value) {
        Poll _oldValue = this.poll;
        fireOnPreWrite("poll", _oldValue, value);
        this.poll = value;
        fireOnPostWrite("poll", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see VotingList#getPoll()
     */
    @Override
    public Poll getPoll() {
        fireOnPreRead("poll", poll);
        Poll result = this.poll;
        fireOnPostRead("poll", poll);
        return result;
    }

    /* (non-Javadoc)
     * @see VotingList#setVote(Vote)
     */
    @Override
    public void setVote(Vote value) {
        Vote _oldValue = this.vote;
        fireOnPreWrite("vote", _oldValue, value);
        this.vote = value;
        fireOnPostWrite("vote", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see VotingList#getVote()
     */
    @Override
    public Vote getVote() {
        fireOnPreRead("vote", vote);
        Vote result = this.vote;
        fireOnPostRead("vote", vote);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("weight", this.weight).
         toString();
        return result;
    }
        
} //VotingListAbstract
