/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Choice}.
 */
public abstract class ChoiceAbstract extends TopiaEntityAbstract implements Choice {

    public String name;

    public String description;

    public Boolean validate;

    public List<VoteToChoice> voteVoteToChoice;

    public Poll poll;

    /**
     * Constructeur de ChoiceAbstract par défaut.
     */
    public ChoiceAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Choice.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Choice.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "description", String.class, description);
        visitor.visit(this, "validate", Boolean.class, validate);
        visitor.visit(this, "voteVoteToChoice", java.util.List.class, VoteToChoice.class, voteVoteToChoice);
        visitor.visit(this, "poll", Poll.class, poll);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        tmp.addAll(((TopiaContextImplementor)getTopiaContext())
            .getDAO(VoteToChoice.class)
            .findAllByProperties("choice", this));

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Choice#setName(String)
     */
    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Choice#getName()
     */
    @Override
    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
    }

    /* (non-Javadoc)
     * @see Choice#setDescription(String)
     */
    @Override
    public void setDescription(String value) {
        String _oldValue = this.description;
        fireOnPreWrite("description", _oldValue, value);
        this.description = value;
        fireOnPostWrite("description", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Choice#getDescription()
     */
    @Override
    public String getDescription() {
        fireOnPreRead("description", description);
        String result = this.description;
        fireOnPostRead("description", description);
        return result;
    }

    /* (non-Javadoc)
     * @see Choice#setValidate(Boolean)
     */
    @Override
    public void setValidate(Boolean value) {
        Boolean _oldValue = this.validate;
        fireOnPreWrite("validate", _oldValue, value);
        this.validate = value;
        fireOnPostWrite("validate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Choice#getValidate()
     */
    @Override
    public Boolean getValidate() {
        fireOnPreRead("validate", validate);
        Boolean result = this.validate;
        fireOnPostRead("validate", validate);
        return result;
    }

    /* (non-Javadoc)
     * @see Choice#addVoteVoteToChoice(VoteToChoice)
     */
    @Override
    public void addVoteVoteToChoice(VoteToChoice value) {
        fireOnPreWrite("voteVoteToChoice", null, value);
        if (this.voteVoteToChoice == null) {
            this.voteVoteToChoice = new ArrayList<VoteToChoice>();
        }
        value.setChoice(this);
        this.voteVoteToChoice.add(value);
        fireOnPostWrite("voteVoteToChoice", this.voteVoteToChoice.size(), null, value);
    }

    /* (non-Javadoc)
     * @see Choice#getVoteByTopiaId(String)
     */
    @Override
    public VoteToChoice getVoteVoteToChoiceByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(voteVoteToChoice, topiaId);
    }

    /* (non-Javadoc)
     * @see Choice#addAllVoteVoteToChoice(List<VoteToChoice>()
     */
    @Override
    public void addAllVoteVoteToChoice(List<VoteToChoice> values) {
        if (values == null) {
            return;
        }
        for (VoteToChoice item : values) {
            addVoteVoteToChoice(item);
        }
    }

    /* (non-Javadoc)
     * @see Choice#setVoteVoteToChoice(List<VoteToChoice>()
     */
    @Override
    public void setVoteVoteToChoice(List<VoteToChoice> values) {
//        clearVoteVoteToChoice();
//        addAllVoteVoteToChoice(values);
// FIXME
        List<VoteToChoice> _oldValue = voteVoteToChoice;
        fireOnPreWrite("voteVoteToChoice", _oldValue, values);
        voteVoteToChoice = values;
        fireOnPostWrite("voteVoteToChoice", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Choice#removeVoteVoteToChoice(VoteToChoice)
     */
    @Override
    public void removeVoteVoteToChoice(VoteToChoice value) {
        fireOnPreWrite("voteVoteToChoice", value, null);
        if ((this.voteVoteToChoice == null) || (!this.voteVoteToChoice.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setChoice(null);
        fireOnPostWrite("voteVoteToChoice", this.voteVoteToChoice.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Choice#clearVoteVoteToChoice()
     */
    @Override
    public void clearVoteVoteToChoice() {
        if (this.voteVoteToChoice == null) {
            return;
        }
        for (VoteToChoice item : this.voteVoteToChoice) {
            item.setChoice(null);
        }
        List<VoteToChoice> _oldValue = new ArrayList<VoteToChoice>(this.voteVoteToChoice);
        fireOnPreWrite("voteVoteToChoice", _oldValue, null);
        this.voteVoteToChoice.clear();
        fireOnPostWrite("voteVoteToChoice", _oldValue, null);
    }

    /* (non-Javadoc)
     * @see Choice#getVoteVoteToChoice()
     */
    @Override
    public List<VoteToChoice> getVoteVoteToChoice() {
        return voteVoteToChoice;
    }

    /* (non-Javadoc)
     * @see Choice#getVoteVoteToChoice(Vote)
     */
    @Override
    public VoteToChoice getVoteVoteToChoice(Vote value) {
        if (value == null || voteVoteToChoice == null) {
            return null;
        }
        for (VoteToChoice item : voteVoteToChoice) {
            if (value.equals(item.getVote())) {
                return item;
            }
        }
        return null;
    }

    /* (non-Javadoc)
     * @see Choice#sizeVoteVoteToChoice()
     */
    @Override
    public int sizeVoteVoteToChoice() {
        if (voteVoteToChoice == null) {
            return 0;
        }
        return voteVoteToChoice.size();
    }

    /* (non-Javadoc)
     * @see Choice#isVoteVoteToChoiceEmpty()
     */
    @Override
    public boolean isVoteVoteToChoiceEmpty() {
        int size = sizeVoteVoteToChoice();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see Choice#setPoll(Poll)
     */
    @Override
    public void setPoll(Poll value) {
        Poll _oldValue = this.poll;
        fireOnPreWrite("poll", _oldValue, value);
        this.poll = value;
        fireOnPostWrite("poll", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Choice#getPoll()
     */
    @Override
    public Poll getPoll() {
        fireOnPreRead("poll", poll);
        Poll result = this.poll;
        fireOnPostRead("poll", poll);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("description", this.description).
            append("validate", this.validate).
         toString();
        return result;
    }
        
} //ChoiceAbstract
