/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.converters;

import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;

/**
 * Classe de conversion d'entitées en DTO pour le voteCounting.
 *
 * @author fdesbois
 * @version $Id: EntityToVoteCountingDTO.java 2621 2009-07-03 15:09:23Z nrannou $
 */
public class EntityToVoteCountingDTO extends DataConverter {

    public static PollDTO createPollDTOForVoteCounting(Poll entity) {

        PollDTO dto = new PollDTO(entity.getPollId(), entity.getMaxChoiceNb(),
                EnumController.getPollType(entity), EnumController
                        .getVoteCountingType(entity));

        for (Choice choice : entity.getChoice()) {
            dto.getChoices().add(createPollChoiceDTO(choice));
        }
        if (entity.getVotingList() != null && !entity.getVotingList().isEmpty()) {
            for (VotingList list : entity.getVotingList()) {
                dto.getVotingGroups().add(createVotingGroupDTO(list));
            }
        } else {
            // un groupe par défaut si il y en a pas
            VotingGroupDTO group = new VotingGroupDTO("unique", 1);
            for (Vote vote : entity.getVote()) {
                group.getVotingPersons().add(createVotingPersonDTO(vote));
            }
            dto.getVotingGroups().add(group);
        }
        return dto;
    }

    private static PollChoiceDTO createPollChoiceDTO(Choice choice) {
        PollChoiceDTO choiceDTO = new PollChoiceDTO(getChoiceId(choice));
        return choiceDTO;
    }

    private static VotingGroupDTO createVotingGroupDTO(VotingList list) {
        VotingGroupDTO group = new VotingGroupDTO(list.getTopiaId(), list
                .getWeight());

        for (PersonToList pToList : list.getPollAccountPersonToList()) {
            Vote vote = getPollVoteByPollAccount(list.getPoll(), pToList
                    .getPollAccount());
            if (vote != null) { // Pas de vote pour cette personne : doit engendrer erreur ?!?
                group.getVotingPersons().add(createVotingPersonDTO(vote));
            }
        }
        return group;
    }

    private static VotingPersonDTO createVotingPersonDTO(Vote vote) {
        VotingPersonDTO votingPerson = new VotingPersonDTO(vote
                .getPollAccount().getVotingId(), vote.getWeight());

        for (VoteToChoice vToChoice : vote.getChoiceVoteToChoice()) {
            votingPerson.getChoices().add(createVoteToChoiceDTO(vToChoice));
        }
        return votingPerson;
    }

    private static VoteToChoiceDTO createVoteToChoiceDTO(VoteToChoice vToChoice) {
        VoteToChoiceDTO vote = new VoteToChoiceDTO(getChoiceId(vToChoice
                .getChoice()), vToChoice.getVoteValue());

        return vote;
    }

    private static String getChoiceId(Choice choice) {
        return choice.getTopiaId();
    }

    /* A Deplacer au bon endroit (PollImpl) si c'est possible */
    private static Vote getPollVoteByPollAccount(Poll poll, PollAccount account) {
        for (Vote vote : poll.getVote()) {
            if (account.getTopiaId().equals(vote.getPollAccount().getTopiaId())) {
                return vote;
            }
        }
        return null;
    }

}
