/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.List;

import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.persistence.UserAccount;

/**
 * Gestion de la conversion des dtos User en entité et vice-versa.
 *
 * @author enema
 * @version $Id: DataUserConverter.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class DataUserConverter extends DataConverter {

    /**
     * Création d'une entité utilisateur à partir d'un dto utilisateur.
     *
     * @param userDTO Le dto utilisateur
     * @param eUser L'entité utilisateur
     */
    public void populateUserEntity(UserDTO userDTO, UserAccount eUser,
            String password) {
        eUser.setLogin(userDTO.getLogin());
        eUser.setEmail(userDTO.getEmail());
        eUser.setFirstName(userDTO.getFirstName());
        eUser.setLastName(userDTO.getLastName());
        eUser.setLangage(userDTO.getLangage());
        eUser.setAdministrator(userDTO.isAdministrator());
        eUser.setPassword(password);
    }

    /**
     * Mise à jour d'un utilisateur à partir d'un dto utilisateur.
     *
     * @param userDTO Le dto utilisateur
     * @param eUser l'entité utilisateur
     */
    public void populateUserEntity(UserDTO userDTO, UserAccount eUser) {
        eUser.setEmail(userDTO.getEmail());
        eUser.setFirstName(userDTO.getFirstName());
        eUser.setLastName(userDTO.getLastName());
        eUser.setLangage(userDTO.getLangage());
        eUser.setAdministrator(userDTO.isAdministrator());
    }

    /**
     * Création d'un DTO utilisateur à partir d'une entité utilisateur.
     *
     * @param eUser L'entité utilisateur
     * @return Le DTO utilisateur
     */
    public UserDTO createUserDTO(UserAccount eUser) {
        UserDTO userDTO = new UserDTO();
        userDTO.setId(eUser.getTopiaId());
        userDTO.setLogin(eUser.getLogin());
        userDTO.setEmail(eUser.getEmail());
        userDTO.setFirstName(eUser.getFirstName());
        userDTO.setLastName(eUser.getLastName());
        userDTO.setLangage(eUser.getLangage());
        userDTO.isAdministrator(eUser.getAdministrator());
        return userDTO;
    }

    /**
     * retourne une liste de dtos des utilisateurs à partir d'une liste
     * d'entité.
     *
     * @param lUsers Liste de entités utilisateur
     * @return la liste des dtos utilisateurs
     */
    public List<UserDTO> createUserDTOs(List<UserAccount> lUsers) {
        ArrayList<UserDTO> results = new ArrayList<UserDTO>();
        UserDTO dto;
        for (UserAccount u : lUsers) {
            dto = this.createUserDTO(u);
            results.add(dto);
        }
        return results;
    }
}
