/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.web.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaServiceConfig;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.business.utils.FormatsEnum;
import org.chorem.lima.entity.Account;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.web.action.ReportBuilder;
import org.chorem.lima.web.service.DocumentService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.hibernate.exception.GenericJDBCException;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;

public class HttpServerService {
    protected static final Log log = LogFactory.getLog(HttpServerService.class);
    private DocumentService documentService;
    private AccountService accountService;
    protected Server server;
    protected int port = LimaServiceConfig.getInstance().getHttpPort();
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd");
    protected ReportBuilder reportBuilder;

    public HttpServerService() {
        this.accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);
        this.documentService = new DocumentService();
        this.reportBuilder = new ReportBuilder();
    }

    public void start() {
        if (this.server == null) {
            try {
                LimaServiceConfig config = LimaServiceConfig.getInstance();
                File reportDir = config.getReportsModelDir();
                FileUtil.createDirectoryIfNecessary((File)reportDir);
                this.server = new Server(this.port);
                ServletContextHandler context = new ServletContextHandler(1);
                context.setContextPath("/");
                context.addServlet(new ServletHolder((Servlet)new MainServlet()), "/");
                this.server.setHandler((Handler)context);
                this.server.start();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Web server are running on port: " + this.port));
                }
            }
            catch (Exception eee) {
                log.error((Object)"error while booting http server", (Throwable)eee);
            }
        }
    }

    public int getHttpPort() {
        return this.port;
    }

    public class MainServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private String serverAddressConfig = LimaServiceConfig.getInstance().getAddressServer();

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            block22: {
                try {
                    String account;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"doGet");
                    }
                    String imageParam = req.getParameter("img");
                    String model = req.getParameter("model");
                    String beginDate = req.getParameter("beginDate");
                    String endDate = req.getParameter("endDate");
                    String string = account = StringUtils.isBlank((CharSequence)req.getParameter("account")) ? null : URLDecoder.decode(req.getParameter("account"), "UTF-8");
                    if (imageParam != null) {
                        URL image = Resource.getURLOrNull((String)("images/" + imageParam));
                        if (image != null) {
                            resp.setContentType("image/png");
                            InputStream in = image.openStream();
                            ServletOutputStream out = resp.getOutputStream();
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        break block22;
                    }
                    if (model != null && beginDate != null && endDate != null) {
                        String accountReport = null;
                        String financialReport = null;
                        try {
                            Date beginDateFormat = DATEFORMAT.parse(beginDate);
                            Date endDateFormat = DATEFORMAT.parse(endDate);
                            switch (DocumentsEnum.valueOfLink((String)model)) {
                                case BALANCE: {
                                    HttpServerService.this.documentService.createBalanceDocuments(beginDateFormat, endDateFormat, null);
                                    break;
                                }
                                case ACCOUNT: {
                                    accountReport = HttpServerService.this.documentService.createAccountDocument(beginDateFormat, endDateFormat, account);
                                    break;
                                }
                                case ENTRY_BOOKS: {
                                    HttpServerService.this.documentService.createEntryBooksDocuments(beginDateFormat, endDateFormat, null);
                                    break;
                                }
                                case GENERAL_ENTRY_BOOK: {
                                    HttpServerService.this.documentService.createGeneralEntryBooksDocuments(beginDateFormat, endDateFormat);
                                    break;
                                }
                                case FINANCIAL_STATEMENT: {
                                    financialReport = HttpServerService.this.documentService.createFinancialStatementsDocuments(beginDateFormat, endDateFormat);
                                    break;
                                }
                                case LEDGER: {
                                    HttpServerService.this.documentService.createLedgerDocuments(beginDateFormat, endDateFormat);
                                }
                            }
                        }
                        catch (ParseException eeePE) {
                            log.error((Object)"Can't parse date", (Throwable)eeePE);
                        }
                        if (accountReport != null || financialReport != null) {
                            resp.setContentType(".html");
                            ServletOutputStream out = resp.getOutputStream();
                            String report = accountReport != null ? accountReport : financialReport;
                            IOUtils.write((String)report, (OutputStream)out, (Charset)Charsets.UTF_8);
                        } else {
                            LimaServiceConfig config = LimaServiceConfig.getInstance();
                            File reportDir = config.getReportsModelDir();
                            String path = reportDir.getAbsolutePath();
                            URL doc = new URL("file:" + path + File.separator + model + ".pdf");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("file:" + path + File.separator + model + ".pdf"));
                            }
                            resp.setContentType(".pdf");
                            ServletOutputStream out = resp.getOutputStream();
                            InputStream in = doc.openStream();
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        break block22;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Home html");
                    }
                    resp.setContentType(FormatsEnum.HTML.getMimeType());
                    StringBuilder pageContent = new StringBuilder();
                    String serverAddress = "http://";
                    log.info((Object)"Page load");
                    serverAddress = this.serverAddressConfig.equals("") ? serverAddress + req.getServerName() + ":" + req.getServerPort() : serverAddress + this.serverAddressConfig + ":" + LimaServiceConfig.getInstance().getHttpPort();
                    Calendar calendar = Calendar.getInstance();
                    Date endDatePicker = calendar.getTime();
                    Date beginDatePicker = calendar.getTime();
                    beginDatePicker = DateUtils.truncate((Date)beginDatePicker, (int)1);
                    pageContent.append("<!DOCTYPE html>\n<html lang=\"fr\">\n<head>\n<script type=\"text/javascript\">        function showAccountInput(){          var request = document.getElementById('model');          var requestValue = request == null ? '': request.value;          var isDocumentAccount = requestValue === 'lima_account';           if (document.getElementById('accountField') != null) {            if (isDocumentAccount) {              document.getElementById('accountField').style.display = 'block';            } else {              document.getElementById('accountField').style.display = 'none';            }          }        }      showAccountInput();      </script><title>LIMA Documents Report</title>\n<style type=\"text/css\">body { font: 14px sans-serif; }h1 { font: 20px sans-serif; text-align: center; }table.padding td {padding-right:20px;}.tdright {text-align: right;}</style></head>\n<body>\n<table class=\"padding\">\n<tr><td><img src=\"?img=puzzle_icon_mini.png\"/></td>\n<td><h1>LIMA Documents Report</h1></td></tr>\n<tr><td class=\"tdright\"><img src=\"?img=identity.png\"/></td>\n<td rowspan=3><form method=GET action=").append(serverAddress).append(">\n").append(I18n.t((String)"lima-business.document.date.begin", (Object[])new Object[0])).append("<input value=\"").append(DATEFORMAT.format(beginDatePicker)).append("\" type=\"date\" name=\"beginDate\">\n").append(I18n.t((String)"lima-business.document.date.end", (Object[])new Object[0])).append("<input value=\"").append(DATEFORMAT.format(endDatePicker)).append("\" type=\"date\" name=\"endDate\">\n<br/><br/>");
                    pageContent.append("Documents : <select id=\"model\" name=\"model\" onchange='showAccountInput()'>");
                    for (DocumentsEnum documentsEnum : DocumentsEnum.values()) {
                        pageContent.append("<option value=\"").append(documentsEnum.getFileName()).append("\">").append(documentsEnum.getDescription()).append("</option>\n");
                    }
                    List accounts = HttpServerService.this.accountService.getAllAccounts();
                    StringBuilder optionAccounts = new StringBuilder();
                    for (Account account1 : accounts) {
                        optionAccounts.append("<option value=\"" + account1.getTopiaId() + "\">");
                        optionAccounts.append(account1.getAccountNumber() + " - " + account1.getLabel());
                        optionAccounts.append("</option>\n");
                    }
                    pageContent.append("</select><div id='accountField'>Compte : <select id=\"account\" name=\"account\">" + optionAccounts.toString() + "</select></div>" + "<input type=\"submit\">\n" + "</form></td>" + "<tr><td class=\"tdright\"><img src=\"?img=entries.png\"/></td></tr>\n" + "<tr><td class=\"tdright\"><img src=\"?img=accounts.png\"/></td></tr>\n" + "<tr><td class=\"tdright\"><img src=\"?img=entrybooks.png\"/></td>\n" + "<tr><td class=\"tdright\"><img src=\"?img=fiscalperiods.png\"/></td></tr>\n" + "</table>\n" + "<script type=\"text/javascript\">" + "  showAccountInput();" + "</script>" + "</body>\n" + "</html>");
                    resp.getWriter().write(pageContent.toString());
                }
                catch (GenericJDBCException eee) {
                    log.error((Object)"Can't read db", (Throwable)eee);
                }
            }
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.doGet(req, resp);
        }
    }
}

