package org.chorem.lima.ui.opening;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.exceptions.LimaException;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n.t;

public class CreateFiscalPeriodPanel extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1UQU8TQRR+FAoUKIhEAhENCvHmVFDigYMYSCNNVWI9EHtxuju2A9PdcXYqqwfjT/An6N2LiTdPxoNnD16Mf8EYD16Nb6bb3RbWlh42zbzv+96bN+97735CNlBw6YCGIVEtT/MmI6Xb+/v3awfM0TsscBSX2lfQ/g1lIFOFSTc+DzSsVMuGXojohW2/KX2PeV3szTJMBPq5YEGDMa3hQi/DCYJCJQ5vhrKlOqpxUWmqb37/yrx2X73NAIQSq8vjVZYHsZKbjJQhw10NZzHTM1oQ1KtjGYp7daw3b862BQ2Ce7TJnsJLGCvDqKQKxTRcPv2VrYblh1LD+Gppj3pMXNOw7qs6cRq+Yk0ieJOSFie+ZB7mJ9uKUc2KPHCo2GOK+65lSWmVRjXMrVZsol2Pa04Ff8EUSl6xl3ewGi6YIu1ayAlkX5k1E5ruC1kfDLk+GHJjMGTjGGRs9SGtCYY3Xeh55uDINM3GDDIXE2afdLWwTGtM4HOblw0jTskeGvRiTJqusTr3dvAB4uDFXsRMjNjjziFTGpbNYx6gLw61L9vaISntJ5BegSnmuf0S5KN4wl2JAArO91wdvUMS7yTDPVSFrGrhMfaqetJuDzDUNtrCMaMZQRv9Oz/37eOPD8WOu4Yx97lUaNdywKmXCqdYaW5Sz7St1dJcFO5SuVmFXMAEbha7OZZSCqtEYSwO880aOjF0cocGDZTIjn3/9Hn+8ddhyBRhQvjULVKD34Wcbijsgi/cUN7ashVNHY3j94ypTcOIZiFad9F6rWO07vkIsRtLKd2IS6rlvvyZq7zf6nRkCCtc/C886Ur2EYxyT3CP2Y0TLZPUDTMpA9Zy/WRppK0RSBtsGdnkqv2u9enAjO2Ai+NF7ByHLcPYsBcy/27CCQ+cXjyfiOMMp0n3zD4K/wNDy6EshAYAAA==";
    private static final Log log = LogFactory.getLog(CreateFiscalPeriodPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel beginDateLabel;
    protected JXDatePicker beginDatePicker;
    protected JLabel endDateLabel;
    protected JXDatePicker endDatePicker;
    protected JLabel fiscalPeriodLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CreateFiscalPeriodPanel $JPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected FiscalPeriodService fiscalPeriodService;
    // set begin date picker
            Date endDate;
    Calendar calendarBegin;
    // set begindate to JAN 1 - 0:00.000 of this years
            Date beginDate;
    FiscalPeriod result;
    // get end date
            Calendar calendarEnd;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateFiscalPeriodPanel(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateFiscalPeriodPanel(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateFiscalPeriodPanel() {
        $initialize();
    }

    public CreateFiscalPeriodPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateFiscalPeriodPanel(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateFiscalPeriodPanel(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateFiscalPeriodPanel(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateFiscalPeriodPanel(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getBeginDateLabel() {
        return beginDateLabel;
    }

    public JXDatePicker getBeginDatePicker() {
        return beginDatePicker;
    }

    public JLabel getEndDateLabel() {
        return endDateLabel;
    }

    public JXDatePicker getEndDatePicker() {
        return endDatePicker;
    }

    public JLabel getFiscalPeriodLabel() {
        return fiscalPeriodLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBeginDateLabel() {
        $objectMap.put("beginDateLabel", beginDateLabel = new JLabel());
        
        beginDateLabel.setName("beginDateLabel");
        beginDateLabel.setText(t("lima.date.begin"));
    }

    protected void createBeginDatePicker() {
        $objectMap.put("beginDatePicker", beginDatePicker = new JXDatePicker());
        
        beginDatePicker.setName("beginDatePicker");
    }

    protected void createEndDateLabel() {
        $objectMap.put("endDateLabel", endDateLabel = new JLabel());
        
        endDateLabel.setName("endDateLabel");
        endDateLabel.setText(t("lima.date.end"));
    }

    protected void createEndDatePicker() {
        $objectMap.put("endDatePicker", endDatePicker = new JXDatePicker());
        
        endDatePicker.setName("endDatePicker");
    }

    protected void createFiscalPeriodLabel() {
        $objectMap.put("fiscalPeriodLabel", fiscalPeriodLabel = new JLabel());
        
        fiscalPeriodLabel.setName("fiscalPeriodLabel");
        fiscalPeriodLabel.setText(t("lima.opening.fiscalPeriod"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(fiscalPeriodLabel, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDateLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDatePicker, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDateLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDatePicker, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        fiscalPeriodService = LimaServiceFactory.getService(
                            FiscalPeriodService.class);
        endDate = null;
        calendarBegin = Calendar.getInstance();
        beginDate = calendarBegin.getTime();
        result = fiscalPeriodService.getLastFiscalPeriod();
        calendarEnd = Calendar.getInstance();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFiscalPeriodLabel();
        createBeginDateLabel();
        createBeginDatePicker();
        createEndDateLabel();
        createEndDatePicker();
        // inline creation of $JPanel0
        setName("$JPanel0");
        
        beginDate = DateUtils.truncate(beginDate, Calendar.DATE);if (result != null){
                    beginDate = result.getEndDate();
                };beginDate = DateUtils.addDays(beginDate, 1);getBeginDatePicker().setDate(beginDate);endDate = DateUtils.addYears(beginDate, 1);endDate = DateUtils.addDays(endDate, -1);getEndDatePicker().setDate(endDate);$completeSetup();
    }

}