package org.chorem.lima.ui.home;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class HomeView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWS28jRRBue2OHvB9LQlZkkQkrkYVknNdClCDYPHcTvAQlC7uLD9Ceadu9jKebnjaZEC3iJ/AT4AIXLkjcOCEOnDlwQfsXEOLAFVHdtuflcTLSWnJr3F311VdV7q/mh79QzhXo5cfY8wzRdCRtEONw6+HDo8pjYspd4pqCcskEan0yWZQtoyHL33cleqVcUu7FtntxhzU4c4gT8t4soUFXntnErRMiJboe9TBdt3jiH296vCk6qD6pJNRv/vk7+7X11bdZhDwO7KYglcJlXkEmfSWUpZZEkxDpc1y0sVMDGoI6NeA7ovZ2bOy67+EG+Qx9ifpLKM+xADCJ5tKnrDG0v8cl6r9xH1dssiRRgYmaYdaZIA3Dpg1sNKlRZ8D5LiwfUnLKuXbLSzSMTZNBqPexQ2zgq6h5hnsKTI1DvakMByQaoE6V6Y2OazveskQzkcK0nPWZshzuiuUemMyJxyrhSivWuER9FAw6XiMdL99iqm2Wk1RCYzt2Nw73LArlUSShCC9E4IMj7exzGoXKirNtxj71kx29LOMV9XNSLdcTcHR2Ps1CLJuxwC6aT+HCfJbV5qy280OOV6lrYvsRwcJNT37VJ/+ajzQWQoqwX4yxD4eM0l+8kP6KT3/RD3qtSh3smBTb9wV2XGxKypz0eaz5ebzpQw6p4lISzWEjlsNw2yjKf+NC/qs+/w0OQvBi5P8OEmMEEhNoQKaMcqIJ23BByt2qdAxHLT2aiemRAtSn/01f/ePnpz/td0RoDGJPJZqGNBTEgQvGiZBUhR5rKVBTUrt4D/PNMhpwiQ0CrAV2NoHYSfsYyEG8CeVuKHfjLnbrAJHr//OXX6c/+f0Kyu6jQZthax8r+wPoV11AFZhtefyd25rR8OlzsI7D9wr0p0Ed2mg2TugXUKiZc4ecFnYhrONC6+dXl5YWlm8t3XwCxeeCVIkQxEo2vQWmKyvaNF9hwoJk0fr5tn5qkTkzTEGwJHvSrBOrdTIf/mGUjh7sHe/t3nziQQtmE1rg16Ey8Nu/V09+vN1pQwbKcq2nedCK3EcoTx2bOkRPg7bQJ6r/EHdJ02KBoCdJPOKcd92IA73e6yp3Nl7u6VgN19YX1taTit3D0GuqQB/o/NXTgxad4G5dwKSvytRoe1Uj78Pz/JwLd37RJYJW5xb0lrF9VNpdKCy/oTgNVmF41QToPgzRifMdZjNh7G4dv/vxneOtR724hG5wLzKZNuPQNDK4U+sGjI0r3h6Zl+OGJkEv5NiwSI8dFupe4HExT4/ekc9eyGF5TYMqiQdNn9RvIPr1o1PQJPDomE8P/3wAH1Q1sS6xyZs+xFQQIlTbpBhd8zF9kIloHlDmxP9keHilAM/b+Iw1AX70LQtLXKhQx4L3obe7sDNqHbkUUW1/p5bvkxFeemaE158ZYR0Q/gd70ZRRfQwAAA==";
    private static final Log log = LogFactory.getLog(HomeView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel accountPanel;
    protected JLabel accountsIcon;
    protected JLabel accountsLabel;
    protected JLabel entriesIcon;
    protected JLabel entriesLabel;
    protected JPanel entryBookPanel;
    protected JLabel entryBooksIcon;
    protected JLabel entryBooksLabel;
    protected JPanel financialTransactionPanel;
    protected JLabel fiscalYearsIcon;
    protected JLabel fiscalYearsLabel;
    protected JPanel fiscalYearsPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JEditorPane $JEditorPane0;
    private JEditorPane $JEditorPane1;
    private JEditorPane $JEditorPane2;
    private JEditorPane $JEditorPane3;
    private HomeView $Table0 = this;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HomeView() {
        $initialize();
    }

    public HomeView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getAccountPanel() {
        return accountPanel;
    }

    public JLabel getAccountsIcon() {
        return accountsIcon;
    }

    public JLabel getAccountsLabel() {
        return accountsLabel;
    }

    public JLabel getEntriesIcon() {
        return entriesIcon;
    }

    public JLabel getEntriesLabel() {
        return entriesLabel;
    }

    public JPanel getEntryBookPanel() {
        return entryBookPanel;
    }

    public JLabel getEntryBooksIcon() {
        return entryBooksIcon;
    }

    public JLabel getEntryBooksLabel() {
        return entryBooksLabel;
    }

    public JPanel getFinancialTransactionPanel() {
        return financialTransactionPanel;
    }

    public JLabel getFiscalYearsIcon() {
        return fiscalYearsIcon;
    }

    public JLabel getFiscalYearsLabel() {
        return fiscalYearsLabel;
    }

    public JPanel getFiscalYearsPanel() {
        return fiscalYearsPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JEditorPane get$JEditorPane0() {
        return $JEditorPane0;
    }

    protected JEditorPane get$JEditorPane1() {
        return $JEditorPane1;
    }

    protected JEditorPane get$JEditorPane2() {
        return $JEditorPane2;
    }

    protected JEditorPane get$JEditorPane3() {
        return $JEditorPane3;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccountPanel() {
        if (!allComponentsCreated) {
            return;
        }
        accountPanel.add($Table1);
    }

    protected void addChildrenToEntryBookPanel() {
        if (!allComponentsCreated) {
            return;
        }
        entryBookPanel.add($Table2);
    }

    protected void addChildrenToFinancialTransactionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        financialTransactionPanel.add($Table4);
    }

    protected void addChildrenToFiscalYearsPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fiscalYearsPanel.add($Table3);
    }

    protected void createAccountPanel() {
        $objectMap.put("accountPanel", accountPanel = new JPanel());
        
        accountPanel.setName("accountPanel");
        accountPanel.setLayout(new BoxLayout(accountPanel, BoxLayout.X_AXIS));
    }

    protected void createAccountsIcon() {
        $objectMap.put("accountsIcon", accountsIcon = new JLabel());
        
        accountsIcon.setName("accountsIcon");
    }

    protected void createAccountsLabel() {
        $objectMap.put("accountsLabel", accountsLabel = new JLabel());
        
        accountsLabel.setName("accountsLabel");
        accountsLabel.setText(t("lima.home.accounts"));
    }

    protected void createEntriesIcon() {
        $objectMap.put("entriesIcon", entriesIcon = new JLabel());
        
        entriesIcon.setName("entriesIcon");
    }

    protected void createEntriesLabel() {
        $objectMap.put("entriesLabel", entriesLabel = new JLabel());
        
        entriesLabel.setName("entriesLabel");
        entriesLabel.setText(t("lima.home.entries"));
    }

    protected void createEntryBookPanel() {
        $objectMap.put("entryBookPanel", entryBookPanel = new JPanel());
        
        entryBookPanel.setName("entryBookPanel");
        entryBookPanel.setLayout(new BoxLayout(entryBookPanel, BoxLayout.X_AXIS));
    }

    protected void createEntryBooksIcon() {
        $objectMap.put("entryBooksIcon", entryBooksIcon = new JLabel());
        
        entryBooksIcon.setName("entryBooksIcon");
    }

    protected void createEntryBooksLabel() {
        $objectMap.put("entryBooksLabel", entryBooksLabel = new JLabel());
        
        entryBooksLabel.setName("entryBooksLabel");
        entryBooksLabel.setText(t("lima.home.entryBooks"));
    }

    protected void createFinancialTransactionPanel() {
        $objectMap.put("financialTransactionPanel", financialTransactionPanel = new JPanel());
        
        financialTransactionPanel.setName("financialTransactionPanel");
        financialTransactionPanel.setLayout(new BoxLayout(financialTransactionPanel, BoxLayout.X_AXIS));
    }

    protected void createFiscalYearsIcon() {
        $objectMap.put("fiscalYearsIcon", fiscalYearsIcon = new JLabel());
        
        fiscalYearsIcon.setName("fiscalYearsIcon");
    }

    protected void createFiscalYearsLabel() {
        $objectMap.put("fiscalYearsLabel", fiscalYearsLabel = new JLabel());
        
        fiscalYearsLabel.setName("fiscalYearsLabel");
        fiscalYearsLabel.setText(t("lima.home.fiscalYears"));
    }

    protected void createFiscalYearsPanel() {
        $objectMap.put("fiscalYearsPanel", fiscalYearsPanel = new JPanel());
        
        fiscalYearsPanel.setName("fiscalYearsPanel");
        fiscalYearsPanel.setLayout(new BoxLayout(fiscalYearsPanel, BoxLayout.X_AXIS));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(accountPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(entryBookPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(fiscalYearsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(financialTransactionPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToAccountPanel();
        // inline complete setup of $Table1
        $Table1.add(accountsIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(accountsLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JEditorPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToEntryBookPanel();
        // inline complete setup of $Table2
        $Table2.add(entryBooksIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(entryBooksLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JEditorPane1, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFiscalYearsPanel();
        // inline complete setup of $Table3
        $Table3.add(fiscalYearsIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(fiscalYearsLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JEditorPane2, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFinancialTransactionPanel();
        // inline complete setup of $Table4
        $Table4.add(entriesIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(entriesLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JEditorPane3, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 36 property setters
        accountPanel.setMinimumSize(new Dimension(300,150));
        accountPanel.setPreferredSize(new Dimension(500,220));
        accountPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        accountsIcon.setIcon(SwingUtil.createImageIcon("accounts.png"));
        accountsIcon.setMinimumSize(new Dimension(48,48));
        accountsIcon.setPreferredSize(new Dimension(48,48));
        accountsLabel.setFont(new Font("sans-serif", Font.BOLD, 16));
        accountsLabel.setForeground(Color.DARK_GRAY);
        entryBookPanel.setMinimumSize(new Dimension(300,150));
        entryBookPanel.setPreferredSize(new Dimension(500,220));
        entryBookPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        entryBooksIcon.setIcon(SwingUtil.createImageIcon("entryBooks.png"));
        entryBooksIcon.setMinimumSize(new Dimension(48,48));
        entryBooksIcon.setPreferredSize(new Dimension(48,48));
        entryBooksLabel.setFont(new Font("sans-serif", Font.BOLD, 16));
        entryBooksLabel.setForeground(Color.DARK_GRAY);
        fiscalYearsPanel.setMinimumSize(new Dimension(300,150));
        fiscalYearsPanel.setPreferredSize(new Dimension(500,220));
        fiscalYearsPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        fiscalYearsIcon.setIcon(SwingUtil.createImageIcon("fiscalYears.png"));
        fiscalYearsIcon.setMinimumSize(new Dimension(48,48));
        fiscalYearsIcon.setPreferredSize(new Dimension(48,48));
        fiscalYearsLabel.setFont(new Font("sans-serif", Font.BOLD, 16));
        fiscalYearsLabel.setForeground(Color.DARK_GRAY);
        financialTransactionPanel.setMinimumSize(new Dimension(300,150));
        financialTransactionPanel.setPreferredSize(new Dimension(500,220));
        financialTransactionPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        entriesIcon.setIcon(SwingUtil.createImageIcon("entries.png"));
        entriesIcon.setMinimumSize(new Dimension(48,48));
        entriesIcon.setPreferredSize(new Dimension(48,48));
        entriesLabel.setFont(new Font("sans-serif", Font.BOLD, 16));
        entriesLabel.setForeground(Color.DARK_GRAY);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createAccountPanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createAccountsIcon();
        createAccountsLabel();
        // inline creation of $JEditorPane0
        $objectMap.put("$JEditorPane0", $JEditorPane0 = new AccountsPane(this));
        
        $JEditorPane0.setName("$JEditorPane0");
        createEntryBookPanel();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createEntryBooksIcon();
        createEntryBooksLabel();
        // inline creation of $JEditorPane1
        $objectMap.put("$JEditorPane1", $JEditorPane1 = new EntryBooksPane(this));
        
        $JEditorPane1.setName("$JEditorPane1");
        createFiscalYearsPanel();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        createFiscalYearsIcon();
        createFiscalYearsLabel();
        // inline creation of $JEditorPane2
        $objectMap.put("$JEditorPane2", $JEditorPane2 = new FiscalYearsPane(this));
        
        $JEditorPane2.setName("$JEditorPane2");
        createFinancialTransactionPanel();
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        createEntriesIcon();
        createEntriesLabel();
        // inline creation of $JEditorPane3
        $objectMap.put("$JEditorPane3", $JEditorPane3 = new FinancialTransactionsPane(this));
        
        $JEditorPane3.setName("$JEditorPane3");
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}