package org.chorem.lima.ui;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ClosableTabHeader extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CAN_CLOSE = "canClose";
    public static final String PROPERTY_TITLE = "title";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLOSE_TAB_ENABLED = "closeTab.enabled";
    public static final String BINDING_LABEL_TEXT = "label.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1UTU8UQRCtHdiFBVR0I8EICfgR9eBs9IpRBCVA1o+IB+Je7Jlp2Ca93U13jQwajT/Bn6B3LybePBkPnj14Mf4FYzx4NXbPLDuLOwb20Nvprnr1qt6bfvsDykbD7BZJEl/HAlmb+qs319fvBVs0xFvUhJoplBqyX8kDrwmjUffcIJxtNlx6vZNeX5RtJQUVPdlzDRgxuMupaVGKCNP7M0Jj6mvd67lExXoPtUuqCPX1r5/eq+jlGw8gUZada2XmoKy8k8EGeCxCOGErPSF1TsSmpaGZ2LR8j7izRU6MuUvadBtewFADKopoC4Zw5vAtpxhpfqIQBpAECOek3vTDltS07XPWJn7M/EUuDQk4fUiCZUoiqpVK0yoIZWTIKcK44+Q7nn7GMw8ZDolwCDbqeB61ICWnRPQgcRJQblt2MYlvdiyIv9pwhy6i2oPnwB46srV9sQsxohSdYA2n943bCunnQuaTLjWhrGN7jDDZ7Nf+gb3KVJ/8R3UHmN7+mah9/fD9/VKv1CcLQ3ucaiVQWiqqkbnSxzKdY2S8foeouSZUDeXW5qmNpwqIrXWuLTlbLxusS/eXiWlZiPLQt4+fJh5/GQBvCUa4JNEScfErUMWWtlOQPErUjfmU0djOsF3HHTeEilRkO7YzKm8Qbmhie58q6L1LIKh+/l1beze/13/J8jn13/B8BuVHUGGCM0FTs3d8XGjuUWVoHMncr0UOhszCqmOp6XSd7evQ6+sQobohBV427Knde1euJrFLPZ/24nYXYM+eB4EPIoxtyDA29wkTSKO8RLfmIGr3N2LVYFKshLZyr6UrgdT2C7Nv17OFdJfJtuuHmhKkt9sKd7OLi5eeFxHtYh3EteS40MQ+GUevRQTJTMBEZD+k632oJbfWDoE3RIV7J1ItF4thJizMXxG61bbbBQAA";
    private static final Log log = LogFactory.getLog(ClosableTabHeader.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean canClose;
    protected JButton closeTab;
    protected JLabel label;
    protected ClosableTabHeader tab = this;
    protected String title;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ClosableTabHeader(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ClosableTabHeader(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClosableTabHeader() {
        $initialize();
    }

    public ClosableTabHeader(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClosableTabHeader(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ClosableTabHeader(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClosableTabHeader(boolean param0) {
        super(param0);
        $initialize();
    }

    public ClosableTabHeader(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getCanClose() {
        return canClose;
    }

    public JButton getCloseTab() {
        return closeTab;
    }

    public JLabel getLabel() {
        return label;
    }

    public String getTitle() {
        return title;
    }

    public Boolean isCanClose() {
        return canClose !=null && canClose;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCanClose(Boolean canClose) {
        Boolean oldValue = this.canClose;
        this.canClose = canClose;
        firePropertyChange(PROPERTY_CAN_CLOSE, oldValue, canClose);
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTab() {
        if (!allComponentsCreated) {
            return;
        }
        add(label);
        add(closeTab);
    }

    protected void createCanClose() {
        $objectMap.put("canClose", canClose = true);
    }

    protected void createCloseTab() {
        $objectMap.put("closeTab", closeTab = new JButton());
        
        closeTab.setName("closeTab");
        closeTab.setOpaque(true);
        closeTab.setFocusPainted(false);
    }

    protected void createLabel() {
        $objectMap.put("label", label = new JLabel());
        
        label.setName("label");
        label.setOpaque(false);
        if (label.getFont() != null) {
            label.setFont(label.getFont().deriveFont((float) 12));
        }
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTab();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        closeTab.setIcon(SwingUtil.createActionIcon("closeTab"));
        closeTab.setBorder(BorderFactory.createEmptyBorder());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("tab", tab);
        createTitle();
        createCanClose();
        createLabel();
        createCloseTab();
        // inline creation of tab
        setName("tab");
        setOpaque(false);
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT, true ,"title") {
        
            @Override
            public void processDataBinding() {
                label.setText(t(getTitle()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLOSE_TAB_ENABLED, true ,"canClose") {
        
            @Override
            public void processDataBinding() {
                closeTab.setEnabled(isCanClose());
            }
        });
    }

}