/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.common.AbstractColumn;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class DayColumn
extends AbstractColumn<FinancialTransactionTableModel> {
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("dd");

    public DayColumn() {
        super(Integer.class, I18n.t((String)"lima.financialTransaction.day", (Object[])new Object[0]), true);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = (Entry)((FinancialTransactionTableModel)this.tableModel).get(row);
        FinancialTransaction transaction = entry.getFinancialTransaction();
        Integer result = row == 0 || ((Entry)((FinancialTransactionTableModel)this.tableModel).get(row - 1)).getFinancialTransaction() != transaction ? Integer.valueOf(this.dateFormat.format(transaction.getTransactionDate())) : null;
        return result;
    }

    @Override
    public boolean isCellEditable(int row) {
        return row == 0 || ((Entry)((FinancialTransactionTableModel)this.tableModel).get(row)).getFinancialTransaction() != ((Entry)((FinancialTransactionTableModel)this.tableModel).get(row - 1)).getFinancialTransaction();
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        Date newDate;
        FinancialTransaction transaction = ((Entry)((FinancialTransactionTableModel)this.tableModel).get(row)).getFinancialTransaction();
        boolean update = false;
        if (value != null && (newDate = this.validAndGetNewDay(transaction, value)) != null) {
            boolean bl = update = transaction.getTransactionDate().compareTo(newDate) != 0;
            if (update) {
                transaction.setTransactionDate(newDate);
                if (!((FinancialTransactionTableModel)this.tableModel).updateTransaction(transaction)) {
                    Date previousDate = transaction.getTransactionDate();
                    transaction.setTransactionDate(previousDate);
                    update = false;
                }
            }
        }
        return update;
    }

    protected Date validAndGetNewDay(FinancialTransaction transaction, Object newDayValue) {
        Integer newDay;
        Date result = null;
        if (newDayValue != null && newDayValue instanceof Integer && (newDay = (Integer)newDayValue) > 0) {
            Date previousDate = transaction.getTransactionDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(previousDate);
            int maximum = calendar.getActualMaximum(5);
            if (newDay <= maximum) {
                Date newDate;
                calendar.set(5, newDay);
                result = newDate = calendar.getTime();
            } else {
                result = previousDate;
            }
        }
        return result;
    }
}

