/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.math.BigDecimal;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.common.AbstractColumn;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class CreditColumn
extends AbstractColumn<FinancialTransactionTableModel> {
    public CreditColumn() {
        super(BigDecimal.class, I18n.t((String)"lima.entry.credit", (Object[])new Object[0]), true);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = (Entry)((FinancialTransactionTableModel)this.tableModel).get(row);
        return entry.isDebit() ? BigDecimal.ZERO : entry.getAmount();
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        boolean update;
        Entry entry = (Entry)((FinancialTransactionTableModel)this.tableModel).get(row);
        BigDecimal credit = (BigDecimal)value;
        boolean bl = update = credit.signum() > 0 && (entry.isDebit() || entry.getAmount().compareTo(credit) != 0);
        if (update) {
            BigDecimal previousAmount = entry.getAmount();
            boolean previousDebit = entry.isDebit();
            entry.setAmount(credit);
            entry.setDebit(false);
            if (((FinancialTransactionTableModel)this.tableModel).updateEntry(entry)) {
                ((FinancialTransactionTableModel)this.tableModel).fireTransaction(entry.getFinancialTransaction());
            } else {
                entry.setAmount(previousAmount);
                entry.setDebit(previousDebit);
                update = false;
            }
        }
        return update;
    }
}

