/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingApplicationContext;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.ui.celleditor.StringTableCellEditor;

public class BigDecimalTableCellEditor
extends StringTableCellEditor {
    private static final long serialVersionUID = -3178887048291878246L;
    protected String comma = "";
    private static final Log log = LogFactory.getLog(BigDecimalTableCellEditor.class);

    public BigDecimalTableCellEditor() {
        this.getComponent().setHorizontalAlignment(4);
        this.getComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                BigDecimalTableCellEditor.this.limitComma(e);
            }
        });
    }

    @Override
    public BigDecimal getCellEditorValue() {
        BigDecimal cellEditorValue;
        String valueToConvert;
        int pointIndex;
        String stringValue = super.getCellEditorValue().toString();
        if (StringUtils.isBlank((CharSequence)stringValue)) {
            stringValue = "0";
        }
        if ((pointIndex = (stringValue = stringValue.replaceAll(",", ".")).indexOf(".")) != -1) {
            LimaSwingConfig config = LimaSwingApplicationContext.getContext().getConfig();
            String actualDecimals = stringValue.substring(pointIndex, stringValue.length() - 1);
            if (config.getScale() > actualDecimals.length()) {
                valueToConvert = stringValue;
            } else {
                String roundedStringValue;
                int decimalLength = config.getScale() + pointIndex + 1;
                valueToConvert = roundedStringValue = stringValue.substring(0, pointIndex) + stringValue.substring(pointIndex, decimalLength);
            }
        } else {
            valueToConvert = stringValue;
        }
        try {
            cellEditorValue = new BigDecimal(valueToConvert);
        }
        catch (NumberFormatException e) {
            cellEditorValue = BigDecimal.ZERO;
        }
        return cellEditorValue;
    }

    protected void limitComma(KeyEvent e) {
        if ((String.valueOf(e.getKeyChar()).matches(",") || String.valueOf(e.getKeyChar()).matches("\\.")) && this.comma.equals(",")) {
            this.getComponent().setText(this.getComponent().getText().substring(0, this.getComponent().getText().length() - 1));
        } else if ((String.valueOf(e.getKeyChar()).matches(",") || String.valueOf(e.getKeyChar()).matches("\\.")) && this.comma.equals("")) {
            this.comma = ",";
        } else if (!(this.getComponent().getText().matches(",") && (this.getComponent().getText().matches("\\.") || String.valueOf(e.getKeyChar()).matches(",") && String.valueOf(e.getKeyChar()).matches("\\.")))) {
            this.comma = "";
        }
    }
}

