/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima;

import java.util.Arrays;
import java.util.Date;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaExceptionHandler;
import org.chorem.lima.LimaSplash;
import org.chorem.lima.LimaSwingApplicationContext;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.server.LimaServer;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.MainViewHandler;
import org.chorem.lima.ui.opening.OpeningView;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.i18n.I18n;

public class LimaMain {
    private static final Log log = LogFactory.getLog(LimaMain.class);
    protected static LimaSwingConfig config;
    protected static LimaSplash splash;

    public static void main(String[] args) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Lima starts at " + new Date()));
            log.info((Object)("Args: " + Arrays.toString(args)));
        }
        LimaSwingApplicationContext context = LimaMain.init(args);
        config = context.getConfig();
        config.doAction(1);
        if (config.isLaunchui()) {
            Thread.setDefaultUncaughtExceptionHandler(new LimaExceptionHandler());
            System.setProperty("sun.awt.exception.handler", LimaExceptionHandler.class.getName());
            LimaMain.launch(context);
        }
    }

    public static LimaSwingApplicationContext init(String ... args) throws Exception {
        splash = new LimaSplash();
        splash.initSplash();
        System.setSecurityManager(null);
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        LimaSwingApplicationContext context = LimaSwingApplicationContext.init();
        LimaSwingConfig config = context.getConfig();
        config.parse(args);
        context.initI18n(config);
        return context;
    }

    protected static void launch(LimaSwingApplicationContext context) throws Exception {
        block5: {
            try {
                SwingUtil.initNimbusLoookAndFeel();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)I18n.t((String)"lima.lookAndFeel.nimbus.warning", (Object[])new Object[0]));
            }
        }
        splash.drawVersion(config.getVersion());
        splash.updateProgression(0.1, I18n.t((String)"lima.launch.services", (Object[])new Object[0]));
        LimaServer.launch((ApplicationConfig)config);
        LimaSwingConfig.getInstance().saveForUser(new String[]{"topia.persistence.classes"});
        AccountService accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);
        long accountCount = accountService.getAccountCount();
        if (accountCount == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Propose for default account loading");
            }
            OpeningView openingView = new OpeningView();
            openingView.setSize(800, 400);
            openingView.setLocationRelativeTo(null);
            openingView.setVisible(true);
        } else {
            splash.updateProgression(0.5, I18n.t((String)"lima.launch.accounting", (Object[])new Object[0]));
        }
        splash.updateProgression(0.7, I18n.t((String)"lima.launch.webServer", (Object[])new Object[0]));
        splash.updateProgression(1.0, I18n.t((String)"lima.launch.finished", (Object[])new Object[0]));
        MainViewHandler uiHandler = (MainViewHandler)context.getContextValue(MainViewHandler.class);
        final MainView ui = uiHandler.initUI(context);
        ui.setLocationRelativeTo(null);
        uiHandler.showHomeView((JAXXContext)context);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ui.setVisible(true);
            }
        });
    }

    public static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("Shutdown Lima");
        }

        @Override
        public void run() {
            try {
                LimaSwingApplicationContext.get().close();
                LimaServiceFactory.destroy();
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"lima.init.closed", (Object[])new Object[]{new Date()}));
                }
                Runtime.getRuntime().halt(0);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)I18n.t((String)"lima.init.errorclosing", (Object[])new Object[0]), (Throwable)ex);
                }
                Runtime.getRuntime().halt(1);
            }
        }
    }
}

