/*
 * #%L
 * Lima Swing
 * 
 * $Id: LedgerTableModel.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.3/lima-swing/src/main/java/org/chorem/lima/ui/ledger/LedgerTableModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.ledger;

import static org.nuiton.i18n.I18n.t;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;

/**
 * Entry book table model.
 *
 * @author ore
 * @author chatellier
 * @version $Revision: 3777 $
 *          <p/>
 *          Last update : $Date: 2014-04-14 09:29:08 +0200 (Mon, 14 Apr 2014) $
 *          By : $Author: sbavencoff $
 */
public class LedgerTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** data cache */
    protected List<Object> objects;

    @Override
    public int getRowCount() {
        int result = 0;

        // just prevent too much result
        if (objects != null) {
            result = objects.size();
        }

        return result;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Class<?> getColumnClass(int column) {

        Class<?> result = null;

        switch (column) {
            case 0:
                result = Account.class;
                break;
            case 1:
                result = Date.class;
                break;
            case 2:
                result = EntryBook.class;
                break;
            case 3:
                result = String.class;
                break;
            case 4:
                result = String.class;
                break;
            case 5:
                result = BigDecimal.class;
                break;
            case 6:
                result = BigDecimal.class;
                break;
            case 7:
                result = BigDecimal.class;
                break;
        }

        return result;
    }


    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0:
                res = t("lima.table.account"); //Account
                break;
            case 1:
                res = t("lima.table.date"); //Date
                break;
            case 2:
                res = t("lima.table.entrybook");
                break;
            case 3:
                res = t("lima.table.voucher"); // Voucher
                break;
            case 4:
                res = t("lima.table.description"); //Description
                break;
            case 5:
                res = t("lima.table.debit"); //Debit
                break;
            case 6:
                res = t("lima.table.credit"); //Credit
                break;
            case 7:
                res = t("lima.table.solde");
                break;
        }
        return res;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;

        // just prevent too much result
        if (objects != null) {
            result = objects.get(row);
            SimpleDateFormat simpleDateFormat
                    = new SimpleDateFormat("dd MMMMM yyyy");

            if (result instanceof ReportsDatas) {
                ReportsDatas currentRow = (ReportsDatas) result;
                BigDecimal amountDebit = currentRow.getAmountDebit();
                BigDecimal amountCredit = currentRow.getAmountCredit();

                switch (column) {
                    case 0:
                        if (currentRow.getAccount() != null) {
                            result = currentRow.getAccount().getAccountNumber();
                        } else {
                            result = null;
                        }
                        break;
                    case 1:
                        result = null; // date
                        break;
                    case 2:
                        result = null; //entrybook
                        break;
                    case 3:
                        result = null; // voucher
                        break;
                    case 4:
                        result = null; // description
                        break;
                    case 5:
                        result = amountDebit; // position
                        break;
                    case 6:
                        result = amountCredit;
                        break;
                    case 7:
                        result = amountDebit.subtract(amountCredit);
                        break;
                }
            } else if (result instanceof Entry) {
                Entry currentRow = (Entry) result;
                BigDecimal amountDebit = BigDecimal.ZERO,
                        amountCredit = BigDecimal.ZERO;
                if (currentRow.getDebit()) {
                    amountDebit = currentRow.getAmount();
                } else {
                    amountCredit = currentRow.getAmount();
                }

                switch (column) {
                    case 0:
                        result = null; // account
                        break;
                    case 1: // date
                        result = simpleDateFormat.
                                format(currentRow.getFinancialTransaction().getTransactionDate());
                        break;
                    case 2:
                        if (currentRow.getFinancialTransaction().getEntryBook() != null) {
                            result = currentRow.getFinancialTransaction().getEntryBook().getCode();
                        } else { //entrybook
                            result = null;
                        }
                        break;
                    case 3: // description
                        result = currentRow.getVoucher();
                        break;
                    case 4:
                        result = currentRow.getDescription();
                        break;
                    case 5:
                        result = amountDebit;
                        break;
                    case 6:
                        result = amountCredit;
                        break;
                    case 7:
                        result = amountDebit.subtract(amountCredit);
                        break;
                }

            }
        }
        return result;
    }


    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        // Just read, no write
        return false;
    }


    public void setObjects(List<Object> datasList) {
        objects = datasList;
        fireTableDataChanged();
    }

}
