/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.lettering;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import org.apache.commons.lang3.StringUtils;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.lettering.LetteringTableModel;

public class LettringSelectionModel
extends DefaultListSelectionModel {
    protected LetteringTableModel letteringTableModel;
    protected Entry entry;
    protected int lineSelected;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public LettringSelectionModel(LetteringTableModel letteringTableModel) {
        this.letteringTableModel = letteringTableModel;
    }

    @Override
    public void addSelectionInterval(int row, int column) {
        this.setSelectionInterval(row, column);
    }

    @Override
    public void setSelectionInterval(int row, int column) {
        if (!this.letteringNotExist(row)) {
            if (this.isSelectionEmpty() || !this.isSelectedIndex(row)) {
                this.clearSelection();
                this.lineSelected = row;
                String currentLettring = this.getCurrentLettring();
                for (Entry entry : this.getEntries()) {
                    if (!StringUtils.isNotBlank((CharSequence)entry.getLettering()) || !entry.getLettering().equals(currentLettring)) continue;
                    int entryToSelect = this.letteringTableModel.indexOf(entry);
                    super.addSelectionInterval(entryToSelect, entryToSelect);
                }
            }
        } else {
            for (Entry entry : this.getEntries()) {
                if (StringUtils.isBlank((CharSequence)entry.getLettering())) continue;
                int entryToSelect = this.letteringTableModel.indexOf(entry);
                super.removeSelectionInterval(entryToSelect, entryToSelect);
            }
            if (this.isSelectionEmpty() || !this.isSelectedIndex(row)) {
                super.addSelectionInterval(row, column);
            } else {
                super.removeSelectionInterval(row, column);
            }
        }
    }

    public boolean letteringNotExist(int row) {
        this.entry = (Entry)this.letteringTableModel.get(row);
        String lettering = this.entry.getLettering();
        boolean emptyOrNull = lettering == null || lettering.isEmpty();
        return emptyOrNull;
    }

    public List<Entry> getEntries() {
        return this.letteringTableModel.getValues();
    }

    public String getCurrentLettring() {
        return this.getCurrentEntrySelected().getLettering();
    }

    public Entry getCurrentEntrySelected() {
        return (Entry)this.letteringTableModel.get(this.lineSelected);
    }

    public void selectRoundedAndNewEntries(int indexFirstRoundedEntry, int indexSecondRoundedEntry, Entry newResultRoundedEntry) {
        if (!this.isSelectedIndex(indexFirstRoundedEntry)) {
            this.addSelectionInterval(indexFirstRoundedEntry, indexFirstRoundedEntry);
        }
        if (!this.isSelectedIndex(indexSecondRoundedEntry)) {
            this.addSelectionInterval(indexSecondRoundedEntry, indexSecondRoundedEntry);
        }
        int newEntryIndex = this.letteringTableModel.indexOf(newResultRoundedEntry);
        this.addSelectionInterval(newEntryIndex, newEntryIndex);
    }

    @Override
    public int getSelectionMode() {
        return 2;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        this.firePropertyChange(propertyName, null, newValue);
    }
}

