/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.home;

import java.util.List;
import javax.swing.event.HyperlinkEvent;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.home.AbstractHomePane;
import org.chorem.lima.ui.home.HomeView;
import org.nuiton.i18n.I18n;

public class FiscalPeriodsPane
extends AbstractHomePane
implements ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FiscalPeriodsPane.class);
    protected FiscalPeriodService fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);

    public FiscalPeriodsPane(HomeView view) {
        super(view);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && e.getDescription().equals("#fiscalperiodschart")) {
            MainView ui = (MainView)LimaContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
            ui.getHandler().showFiscalPeriodView((JAXXContext)ui);
        }
    }

    public void refresh() {
        log.debug((Object)"Rafra\u00eechissement fiscal periods pane");
        String htmlBegin = "<font face='sans-serif' size=3><p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";
        try {
            List fiscalPeriods = this.fiscalPeriodService.getAllFiscalPeriods();
            List unblockedFiscalPeriods = this.fiscalPeriodService.getAllUnblockedFiscalPeriods();
            if (unblockedFiscalPeriods.size() > 0) {
                this.setBackground(GREEN_BACKGROUND);
                String fiscalString = unblockedFiscalPeriods.size() + " " + I18n.t((String)"lima.ui.home.fiscalperiod.opened", (Object[])new Object[0]) + "<br/>" + (fiscalPeriods.size() - unblockedFiscalPeriods.size()) + " " + I18n.t((String)"lima.ui.home.fiscalperiod.closed", (Object[])new Object[0]) + "<br/><br/><a href='#fiscalperiodschart'>" + I18n.t((String)"lima.ui.home.fiscalperiod.modify", (Object[])new Object[0]) + "</a>";
                this.setText(htmlBegin + fiscalString + htmlEnd);
            } else {
                this.setBackground(RED_BACKGROUND);
                String fiscalString = I18n.t((String)"lima.ui.home.fiscalperiod.noopen", (Object[])new Object[0]);
                if (fiscalPeriods.size() > 0) {
                    fiscalString = fiscalString + "<br/>" + fiscalPeriods.size() + " " + I18n.t((String)"lima.ui.home.fiscalperiod.closed", (Object[])new Object[0]);
                }
                fiscalString = fiscalString + "<br/><br/><a href='#fiscalperiodschart'>" + I18n.t((String)"lima.ui.home.fiscalperiod.create", (Object[])new Object[0]) + "</a>";
                this.setText(htmlBegin + fiscalString + htmlEnd);
            }
        }
        catch (LimaException eee) {
            log.debug((Object)"Can't get datas home", (Throwable)eee);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        log.debug((Object)("Nom de la m\u00e9thode : " + methodeName));
        if (methodeName.contains("FiscalPeriod") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.refresh();
        }
    }
}

