/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.common;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class CellRouteHorizontalAction
extends AbstractAction {
    JTable table;
    protected int step;
    protected int route1;
    protected int route2;
    protected int nbCell1;
    protected int nbCell2;

    public CellRouteHorizontalAction(JTable table, boolean nextCell) {
        this.table = table;
        this.step = nextCell ? 1 : -1;
    }

    protected void init() {
        this.route1 = this.table.getSelectedColumn();
        this.route2 = this.table.getSelectedRow();
        this.nbCell1 = this.table.getColumnCount();
        this.nbCell2 = this.table.getRowCount();
    }

    protected int getRow() {
        return this.route2;
    }

    protected int getColumn() {
        return this.route1;
    }

    protected boolean isEditable() {
        return this.table.getModel().isCellEditable(this.getRow(), this.getColumn());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.init();
        if (this.route1 >= 0 && this.route2 >= 0) {
            do {
                this.route1 += this.step;
                if (this.route1 >= 0 && this.route1 < this.nbCell1) continue;
                this.route1 %= this.nbCell1;
                if (this.route1 < 0) {
                    this.route1 += this.nbCell1;
                }
                this.route2 += this.step;
                if (this.route2 >= 0 && this.route2 < this.nbCell2) continue;
                this.route2 %= this.nbCell2;
                if (this.route2 >= 0) continue;
                this.route2 += this.nbCell2;
            } while (!this.isEditable());
            if (this.table.isEditing()) {
                TableCellEditor editor = this.table.getCellEditor();
                editor.stopCellEditing();
            }
            this.table.changeSelection(this.getRow(), this.getColumn(), false, false);
        }
    }
}

