/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.LimaRendererUtil;
import org.chorem.lima.ui.combobox.EntryBookComboBoxModel;
import org.chorem.lima.util.EntryBookToString;
import org.chorem.lima.widgets.JWideComboBox;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class EntryBookTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected static final Log log = LogFactory.getLog(EntryBookTableCellEditor.class);
    private final JWideComboBox comboBox = new JWideComboBox();
    private static final long serialVersionUID = 1L;
    private static boolean keyPressed;

    public EntryBookTableCellEditor() {
        EntryBookComboBoxModel entryBookComboBoxModel = new EntryBookComboBoxModel();
        this.comboBox.setModel(entryBookComboBoxModel);
        ListCellRenderer renderer = LimaRendererUtil.newDecoratorListCellRenderer(EntryBook.class);
        this.comboBox.setRenderer(renderer);
        AutoCompleteDecorator.decorate((JComboBox)this.comboBox, (ObjectToStringConverter)EntryBookToString.getInstance());
        this.comboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!keyPressed) {
                    JTextComponent edit = (JTextComponent)EntryBookTableCellEditor.this.comboBox.getEditor().getEditorComponent();
                    edit.select(1, edit.getText().length());
                    keyPressed = true;
                }
                if (e.getKeyChar() == '\n') {
                    EntryBookTableCellEditor.this.stopCellEditing();
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof EntryBook) {
            this.comboBox.setSelectedItem(value);
        }
        return this.comboBox;
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBox.getSelectedItem();
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        KeyEvent keyEvent;
        if (evt instanceof KeyEvent && (keyEvent = (KeyEvent)evt).getKeyChar() != '\u001b') {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EntryBookTableCellEditor.this.comboBox.getEditor().getEditorComponent().requestFocus();
                    JTextComponent edit = (JTextComponent)EntryBookTableCellEditor.this.comboBox.getEditor().getEditorComponent();
                    if (!Character.isIdentifierIgnorable(keyEvent.getKeyChar())) {
                        edit.setText(Character.toString(keyEvent.getKeyChar()));
                    }
                }
            });
        }
        keyPressed = false;
        return !(evt instanceof MouseEvent) || ((MouseEvent)evt).getClickCount() == 1;
    }
}

