/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.fiscalperiod;

import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import jaxx.runtime.JAXXContext;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryBookImpl;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.fiscalperiod.AddPeriod;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodTable;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodTableModel;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodView;
import org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;

public class FiscalPeriodViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(FiscalPeriodViewHandler.class);
    protected FiscalPeriodView view;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialTransactionService financialTransactionService;

    public FiscalPeriodViewHandler(FiscalPeriodView view) {
        this.view = view;
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
    }

    public void init() {
        this.loadAllFiscalPeriod();
    }

    public void loadAllFiscalPeriod() {
        List periods = this.fiscalPeriodService.getAllFiscalPeriods();
        this.view.getFiscalPeriodTableModel().setFiscalPeriods(periods);
    }

    public void addFiscalPeriod() {
        FiscalPeriodTableModel model = (FiscalPeriodTableModel)this.view.getFiscalPeriodTable().getModel();
        AddPeriod addPeriodDialog = new AddPeriod((JAXXContext)this.view);
        addPeriodDialog.setLocationRelativeTo((Component)((Object)this.view));
        addPeriodDialog.setVisible(true);
        FiscalPeriod fiscalPeriod = addPeriodDialog.getPeriod();
        if (fiscalPeriod != null) {
            int nbMonth = DateUtil.getDifferenceInMonths((Date)fiscalPeriod.getBeginDate(), (Date)fiscalPeriod.getEndDate());
            int response = 0;
            if (nbMonth != 12) {
                response = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.ui.fiscalperiod.addfiscalperiod.morethan12", (Object[])new Object[0]), I18n._((String)"lima.ui.fiscalperiod.addfiscalperiodtitle", (Object[])new Object[0]), 0, 3);
            }
            if (response == 0) {
                fiscalPeriod = this.fiscalPeriodService.createFiscalPeriod(fiscalPeriod);
                model.addFiscalPeriod(fiscalPeriod);
            }
        }
    }

    public void deleteFiscalPeriod() {
        FiscalPeriodTable fiscalPeriodeTable = this.view.getFiscalPeriodTable();
        FiscalPeriodTableModel model = (FiscalPeriodTableModel)this.view.getFiscalPeriodTable().getModel();
        int response = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.ui.fiscalperiod.delete.confirmation", (Object[])new Object[0]), I18n._((String)"lima.ui.fiscalperiod.delete.title", (Object[])new Object[0]), 0, 2);
        int selectedRow = fiscalPeriodeTable.getSelectedRow();
        FiscalPeriod selectedFiscalPeriod = model.getFiscalPeriodAt(selectedRow);
        if (response == 0) {
            this.fiscalPeriodService.deleteFiscalPeriod(selectedFiscalPeriod);
            model.deleteFiscalPeriod(selectedFiscalPeriod);
            this.view.getModel().setBlockEnabled(false);
            this.view.getModel().setDeleteEnabled(false);
        }
    }

    public void init(AddPeriod addPeriod) {
        Date beginDate;
        Date endDate;
        block3: {
            addPeriod.getRootPane().setDefaultButton(addPeriod.getOkButton());
            endDate = null;
            Calendar calendarBegin = Calendar.getInstance();
            beginDate = calendarBegin.getTime();
            beginDate = DateUtils.truncate((Date)beginDate, (int)5);
            try {
                FiscalPeriod result = this.fiscalPeriodService.getLastFiscalPeriod();
                if (result != null) {
                    beginDate = result.getEndDate();
                }
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Can't get last fiscal period", (Throwable)eee);
            }
        }
        beginDate = DateUtils.addDays((Date)beginDate, (int)1);
        addPeriod.getBeginDatePicker().setDate(beginDate);
        endDate = DateUtils.addYears((Date)beginDate, (int)1);
        endDate = DateUtils.addDays((Date)endDate, (int)-1);
        addPeriod.getEndDatePicker().setDate(endDate);
    }

    public void blockFiscalPeriod() {
        FiscalPeriodTable fiscalPeriodeTable = this.view.getFiscalPeriodTable();
        FiscalPeriodTableModel model = this.view.getFiscalPeriodTableModel();
        int selectedRow = fiscalPeriodeTable.getSelectedRow();
        FiscalPeriod selectedFiscalPeriod = model.getFiscalPeriodAt(selectedRow);
        int answerBlock = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.ui.fiscalperiod.block.confirmation", (Object[])new Object[0]), I18n._((String)"lima.ui.fiscalperiod.block.title", (Object[])new Object[0]), 0, 2);
        if (answerBlock == 0) {
            boolean retainedEarnings = false;
            EntryBook entryBook = null;
            int answerCreate = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.ui.fiscalperiod.block.newyear", (Object[])new Object[0]), I18n._((String)"lima.ui.fiscalperiod.block.title", (Object[])new Object[0]), 0, 3);
            if (answerCreate == 0) {
                int answerRetainedEarnings;
                this.addFiscalPeriod();
                if (this.fiscalPeriodService.isRetainedEarnings(selectedFiscalPeriod) && (answerRetainedEarnings = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.ui.fiscalperiod.block.addretainedearnings", (Object[])new Object[0]), I18n._((String)"lima.ui.fiscalperiod.block.title", (Object[])new Object[0]), 0, 3)) == 0) {
                    retainedEarnings = true;
                    EntryBookImpl newEntryBook = new EntryBookImpl();
                    RetainedEarningsEntryBookForm entryBookForm = new RetainedEarningsEntryBookForm((JAXXContext)this.view);
                    entryBookForm.setEntryBook((EntryBook)newEntryBook);
                    entryBookForm.setLocationRelativeTo((Component)((Object)this.view));
                    entryBookForm.setVisible(true);
                    entryBook = entryBookForm.getEntryBook();
                }
            }
            FiscalPeriod fiscalPeriodBlocked = this.fiscalPeriodService.retainedEarningsAndBlockFiscalPeriod(selectedFiscalPeriod, entryBook, retainedEarnings);
            model.updateFiscalPeriod(fiscalPeriodBlocked);
            this.view.getModel().setBlockEnabled(false);
            this.view.getModel().setDeleteEnabled(false);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("importAll")) {
            this.loadAllFiscalPeriod();
        }
    }

    protected void onSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            FiscalPeriodTableModel fiscalPeriodTableModel;
            int selectedRow;
            DefaultListSelectionModel listSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectedIndex(selectedRow = listSelectionEvent.getFirstIndex())) {
                selectedRow = listSelectionEvent.getLastIndex();
            }
            if ((fiscalPeriodTableModel = this.view.getFiscalPeriodTableModel()).getRowCount() != selectedRow) {
                FiscalPeriod fiscalPeriodAt = fiscalPeriodTableModel.getFiscalPeriodAt(selectedRow);
                List financialTransactionList = this.financialTransactionService.getAllFinancialTransactions(fiscalPeriodAt);
                boolean enableBlock = false;
                boolean enableDelete = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"reloadEnablingButton");
                }
                if (selectedRow != -1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"selectedFiscalPeriod != null");
                    }
                    if (!fiscalPeriodAt.getLocked()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"selectedFiscalPeriod not locked");
                        }
                        enableBlock = true;
                        enableDelete = financialTransactionList.size() <= 0;
                    }
                }
                this.view.getModel().setBlockEnabled(enableBlock);
                this.view.getModel().setDeleteEnabled(enableDelete);
            }
        }
    }
}

