/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.fiscalperiod;

import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FiscalPeriod;
import org.nuiton.i18n.I18n;

public class FiscalPeriodTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 77027335135838258L;
    private static final Log log = LogFactory.getLog(FiscalPeriodTableModel.class);
    protected List<FiscalPeriod> fiscalPeriods;

    public void setFiscalPeriods(List<FiscalPeriod> fiscalPeriods) {
        this.fiscalPeriods = fiscalPeriods;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.fiscalPeriods != null) {
            result = this.fiscalPeriods.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public FiscalPeriod getFiscalPeriodAt(int row) {
        if (row == -1) {
            return null;
        }
        FiscalPeriod result = this.fiscalPeriods.get(row);
        return result;
    }

    public int getRow(FiscalPeriod period) {
        if (period == null) {
            return -1;
        }
        return this.fiscalPeriods.indexOf(period);
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result = "n/a";
        switch (columnIndex) {
            case 0: {
                result = I18n._((String)"lima.ui.fiscalperiod.fiscalperiod", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n._((String)"lima.ui.fiscalperiod.closure", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result = "n/a";
        FiscalPeriod fiscalPeriod = this.getFiscalPeriodAt(rowIndex);
        if (fiscalPeriod != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy");
            switch (columnIndex) {
                case 0: {
                    result = simpleDateFormat.format(fiscalPeriod.getBeginDate()) + " - " + simpleDateFormat.format(fiscalPeriod.getEndDate());
                    break;
                }
                case 1: {
                    result = fiscalPeriod.getLocked() ? I18n._((String)"lima.ui.fiscalperiod.closed", (Object[])new Object[0]) : I18n._((String)"lima.ui.fiscalperiod.open", (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    public void addFiscalPeriod(FiscalPeriod fiscalPeriod) {
        this.fiscalPeriods.add(fiscalPeriod);
        int row = this.fiscalPeriods.indexOf(fiscalPeriod);
        this.fireTableRowsInserted(row, row);
    }

    public void deleteFiscalPeriod(FiscalPeriod fiscalPeriod) {
        int row = this.fiscalPeriods.indexOf(fiscalPeriod);
        this.fiscalPeriods.remove(fiscalPeriod);
        this.fireTableRowsDeleted(row, row);
    }

    public void updateFiscalPeriod(FiscalPeriod fiscalPeriod) throws LimaException {
        int row = this.fiscalPeriods.indexOf(fiscalPeriod);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected row : " + row));
        }
        this.fiscalPeriods.set(row, fiscalPeriod);
        this.fireTableRowsUpdated(row, row);
    }
}

