/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionunbalanced;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.utils.EntryComparator;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryImpl;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.util.decorator.DecoratorProvider;

public class FinancialTransactionUnbalancedTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = 3914954536809622358L;
    protected final FinancialTransactionService financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
    protected FiscalPeriod selectedFiscalPeriod;
    protected List<Object> cacheDataList;
    protected final Decorator<Account> accountDecorator;

    public FinancialTransactionUnbalancedTableModel() {
        LimaServiceFactory.addServiceListener((Object)this.financialTransactionService, (ServiceListener)this);
        DecoratorProvider decoratorProvider = LimaContext.get().getDecoratorProvider();
        this.accountDecorator = decoratorProvider.getDecoratorByType(Account.class);
    }

    protected List<Object> getDataList() {
        ArrayList<Object> results = new ArrayList<Object>();
        if (this.selectedFiscalPeriod != null) {
            List financialtransactions = this.financialTransactionService.getAllInexactFinancialTransactions(this.selectedFiscalPeriod);
            for (FinancialTransaction financialtransaction : financialtransactions) {
                results.add(financialtransaction);
                List entries = (List)financialtransaction.getEntry();
                Collections.sort(entries, new EntryComparator());
                results.addAll(entries);
            }
        }
        return results;
    }

    public void refresh() {
        this.cacheDataList = this.getDataList();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        switch (column) {
            case 0: {
                result = Date.class;
                break;
            }
            case 1: {
                result = EntryBook.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = Account.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            case 5: {
                result = BigDecimal.class;
                break;
            }
            case 6: {
                result = BigDecimal.class;
                break;
            }
            case 7: {
                result = BigDecimal.class;
                break;
            }
            case 8: {
                result = String.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = "n/a";
        switch (column) {
            case 0: {
                result = I18n._((String)"lima.table.date", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n._((String)"lima.table.entrybook", (Object[])new Object[0]);
                break;
            }
            case 2: {
                result = I18n._((String)"lima.table.voucher", (Object[])new Object[0]);
                break;
            }
            case 3: {
                result = I18n._((String)"lima.table.account", (Object[])new Object[0]);
                break;
            }
            case 4: {
                result = I18n._((String)"lima.table.description", (Object[])new Object[0]);
                break;
            }
            case 5: {
                result = I18n._((String)"lima.table.debit", (Object[])new Object[0]);
                break;
            }
            case 6: {
                result = I18n._((String)"lima.table.credit", (Object[])new Object[0]);
                break;
            }
            case 7: {
                result = I18n._((String)"lima.table.balance", (Object[])new Object[0]);
                break;
            }
            case 8: {
                result = I18n._((String)"lima.table.letter", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.size();
        }
        return result;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.get(row);
            if (result instanceof FinancialTransaction) {
                FinancialTransaction currentRow = (FinancialTransaction)result;
                BigDecimal amountDebit = currentRow.getAmountDebit();
                BigDecimal amountCredit = currentRow.getAmountCredit();
                switch (column) {
                    case 0: {
                        result = currentRow.getTransactionDate();
                        break;
                    }
                    case 1: {
                        if (currentRow.getEntryBook() != null) {
                            result = currentRow.getEntryBook().getCode();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 2: {
                        result = null;
                        break;
                    }
                    case 3: {
                        result = null;
                        break;
                    }
                    case 4: {
                        result = null;
                        break;
                    }
                    case 5: {
                        result = amountDebit;
                        break;
                    }
                    case 6: {
                        result = amountCredit;
                        break;
                    }
                    case 7: {
                        result = amountDebit.subtract(amountCredit);
                        break;
                    }
                    case 8: {
                        result = null;
                    }
                }
            } else if (result instanceof Entry) {
                Entry currentEntry = (Entry)result;
                switch (column) {
                    case 0: {
                        result = null;
                        break;
                    }
                    case 1: {
                        result = null;
                        break;
                    }
                    case 2: {
                        result = currentEntry.getVoucher();
                        break;
                    }
                    case 3: {
                        if (currentEntry.getAccount() == null) {
                            result = null;
                            break;
                        }
                        Account acc = currentEntry.getAccount();
                        result = this.accountDecorator.toString((Object)acc);
                        break;
                    }
                    case 4: {
                        result = currentEntry.getDescription();
                        break;
                    }
                    case 5: {
                        result = currentEntry.getDebit() ? currentEntry.getAmount() : BigDecimal.ZERO;
                        break;
                    }
                    case 6: {
                        result = currentEntry.getDebit() ? BigDecimal.ZERO : currentEntry.getAmount();
                        break;
                    }
                    case 7: {
                        result = null;
                        break;
                    }
                    case 8: {
                        result = currentEntry.getLettering();
                    }
                }
            }
        }
        return result;
    }

    public void setFiscalPeriod(FiscalPeriod fiscalPeriod) {
        this.selectedFiscalPeriod = fiscalPeriod;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean editableCell = false;
        Object currentRow = this.cacheDataList.get(rowIndex);
        if (currentRow instanceof Entry && columnIndex != 0 && columnIndex != 1) {
            editableCell = true;
        }
        if (currentRow instanceof FinancialTransaction && (columnIndex == 0 || columnIndex == 1)) {
            editableCell = true;
        }
        return editableCell;
    }

    public int addEmptyEntry(Object value, String description, int row) {
        FinancialTransaction currentTransaction = null;
        Object currentRow = this.cacheDataList.get(row);
        EntryImpl entry = new EntryImpl();
        entry.setAmount(BigDecimal.ZERO);
        if (description != null) {
            entry.setDescription(description);
        }
        if (currentRow instanceof FinancialTransaction) {
            currentTransaction = (FinancialTransaction)currentRow;
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            currentTransaction = currentEntry.getFinancialTransaction();
        }
        entry.setFinancialTransaction(currentTransaction);
        Entry newEntry = this.financialTransactionService.createEntry((Entry)entry);
        int newrow = this.cacheDataList.indexOf(newEntry);
        this.fireTableRowsInserted(row, row);
        return newrow;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        boolean financialTransactionRow = false;
        if (this.selectedFiscalPeriod != null) {
            Object currentRow = this.cacheDataList.get(row);
            if (currentRow instanceof FinancialTransaction) {
                FinancialTransaction currentFinancialTransaction = (FinancialTransaction)currentRow;
                switch (column) {
                    case 0: {
                        currentFinancialTransaction.setTransactionDate((Date)value);
                        break;
                    }
                    case 1: {
                        currentFinancialTransaction.setEntryBook((EntryBook)value);
                    }
                }
                this.financialTransactionService.updateFinancialTransaction(currentFinancialTransaction);
            } else if (currentRow instanceof Entry) {
                Entry currentEntry = (Entry)currentRow;
                switch (column) {
                    case 2: {
                        currentEntry.setVoucher((String)value);
                        break;
                    }
                    case 3: {
                        currentEntry.setAccount((Account)value);
                        break;
                    }
                    case 4: {
                        currentEntry.setDescription((String)value);
                        break;
                    }
                    case 5: {
                        currentEntry.setAmount((BigDecimal)value);
                        currentEntry.setDebit(true);
                        break;
                    }
                    case 6: {
                        currentEntry.setAmount((BigDecimal)value);
                        currentEntry.setDebit(false);
                        break;
                    }
                    case 8: {
                        currentEntry.setLettering((String)value);
                    }
                }
                this.financialTransactionService.updateEntry(currentEntry);
            }
            this.cacheDataList = this.getDataList();
            this.fireTableDataChanged();
        }
    }

    public Object getElementAt(int row) {
        Object currentRow = this.cacheDataList.get(row);
        return currentRow;
    }

    public void removeObject(Object object, int row) {
        Object currentRow = this.cacheDataList.get(row);
        if (currentRow instanceof FinancialTransaction) {
            FinancialTransaction currentTransaction = (FinancialTransaction)currentRow;
            this.financialTransactionService.removeFinancialTransaction(currentTransaction);
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            this.financialTransactionService.removeEntry(currentEntry);
        }
        this.refresh();
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("importEntries") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

