/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.Component;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.FinancialStatementWayEnum;
import org.chorem.lima.beans.FinancialTransactionSearch;
import org.chorem.lima.beans.FinancialTransactionSearchImpl;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchTable;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchTableModel;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchView;
import org.nuiton.i18n.I18n;

public class FinancialTransactionSearchViewHandler {
    private static final Log log = LogFactory.getLog(FinancialTransactionSearchViewHandler.class);
    protected FinancialTransactionSearchView view;
    protected FinancialTransactionSearchTable table;
    protected FinancialTransactionSearchTableModel tableModel;
    protected final FinancialTransactionService financialTransactionService;
    protected FinancialTransactionSearch financialTransactionSearch;
    protected Object clipBoard;

    protected FinancialTransactionSearchViewHandler(FinancialTransactionSearchView view) {
        this.view = view;
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
        this.financialTransactionSearch = new FinancialTransactionSearchImpl();
    }

    public void setBeginDate(Date beginDate) {
        this.financialTransactionSearch.setBeginDate(beginDate);
    }

    public void setEndDate(Date endDate) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End date passed : " + endDate));
        }
        this.financialTransactionSearch.setEndDate(endDate);
    }

    public void setVoucher(String voucher) {
        String result = null;
        if (!voucher.equals("")) {
            result = voucher;
        }
        this.financialTransactionSearch.setVoucher(result);
    }

    public void setDescription(String description) {
        String result = null;
        if (!description.equals("")) {
            result = description;
        }
        this.financialTransactionSearch.setDescription(result);
    }

    public void setLetter(String lettering) {
        this.financialTransactionSearch.setLettering(lettering);
    }

    public String getLetter() {
        return this.financialTransactionSearch.getLettering();
    }

    public String getAccountsList() {
        return this.financialTransactionSearch.getAccountList();
    }

    public void setAccountsList(String accountsList) {
        String result = null;
        if (!accountsList.equals("")) {
            result = accountsList;
        }
        this.financialTransactionSearch.setAccountList(result);
    }

    public Account getAccount() {
        return this.financialTransactionSearch.getAccount();
    }

    public void setAccount(Account account) {
        this.financialTransactionSearch.setAccount(account);
    }

    public void setEntryBook(EntryBook entryBook) {
        this.financialTransactionSearch.setEntryBook(entryBook);
    }

    public String getAmount() {
        return this.financialTransactionSearch.getAmount();
    }

    public void setAmount(String amount) {
        String result = null;
        if (!amount.equals("")) {
            result = amount;
        }
        this.financialTransactionSearch.setAmount(result);
    }

    public String getAmount2() {
        return this.financialTransactionSearch.getAmount2();
    }

    public void setAmount2(String amount2) {
        String result = null;
        if (!amount2.equals("")) {
            result = amount2;
        }
        this.financialTransactionSearch.setAmount2(result);
    }

    public void setAmountWayEnum(FinancialStatementWayEnum amountWayEnum) {
        this.financialTransactionSearch.setAmountWayEnum(amountWayEnum);
    }

    public void setOperator(String operator) {
        String result = null;
        if (!operator.equals("")) {
            result = operator;
        }
        this.financialTransactionSearch.setOperator(result);
    }

    public void deleteSelectedRow() {
        this.table = this.view.getFinancialTransactionSearchTable();
        this.tableModel = this.view.getFinancialTransactionSearchTableModel();
        int indexSelectedRow = this.table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = this.tableModel.getElementAt(indexSelectedRow);
            String message = selectedValue instanceof FinancialTransaction ? I18n._((String)"lima.charts.financialtransaction.question.removetransaction", (Object[])new Object[0]) : I18n._((String)"lima.charts.financialtransaction.question.removeentry", (Object[])new Object[0]);
            int response = JOptionPane.showConfirmDialog((Component)((Object)this.view), message, I18n._((String)"lima.common.confirmation", (Object[])new Object[0]), 0);
            if (response == 0) {
                this.tableModel.removeObject(selectedValue, indexSelectedRow);
                ListSelectionModel selectionModel = this.table.getSelectionModel();
                selectionModel.setSelectionInterval(indexSelectedRow - 1, indexSelectedRow - 1);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call delete selected row without selection");
        }
    }

    public void addEmptyEntry() {
        this.table = this.view.getFinancialTransactionSearchTable();
        this.tableModel = this.view.getFinancialTransactionSearchTableModel();
        int indexSelectedRow = this.table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = this.tableModel.getElementAt(indexSelectedRow);
            String description = (String)this.tableModel.getValueAt(indexSelectedRow, 4);
            int index = this.tableModel.addEmptyEntry(selectedValue, description, indexSelectedRow);
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            selectionModel.setSelectionInterval(indexSelectedRow + 1, indexSelectedRow + 1);
            this.table.changeSelection(index, 1, false, false);
            this.table.requestFocusInWindow();
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call addentry selected transaction without selection");
        }
    }

    public void copyRow() {
        this.table = this.view.getFinancialTransactionSearchTable();
        int indexSelectedRow = this.table.getSelectedRow();
        if (indexSelectedRow != -1) {
            this.clipBoard = this.tableModel.getElementAt(indexSelectedRow);
        }
    }

    public void pasteRow() {
        this.table = this.view.getFinancialTransactionSearchTable();
        int indexSelectedRow = this.table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = this.tableModel.getElementAt(indexSelectedRow);
            if (this.clipBoard instanceof Entry) {
                int index = this.tableModel.addEntry(selectedValue, (Entry)this.clipBoard, indexSelectedRow);
                ListSelectionModel selectionModel = this.table.getSelectionModel();
                selectionModel.setSelectionInterval(indexSelectedRow + 1, indexSelectedRow + 1);
                this.table.changeSelection(index, 1, false, false);
                this.table.requestFocusInWindow();
            }
        }
    }

    public void addFinancialTransaction() {
        this.table = this.view.getFinancialTransactionSearchTable();
        this.tableModel = this.view.getFinancialTransactionSearchTableModel();
        int index = this.tableModel.addFinancialTransaction();
        int numberRow = this.table.getRowCount();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setSelectionInterval(numberRow - 1, numberRow - 1);
        this.table.changeSelection(index, 0, false, false);
        this.table.requestFocusInWindow();
    }

    public void refresh() {
        this.tableModel = this.view.getFinancialTransactionSearchTableModel();
        if (this.tableModel != null) {
            this.tableModel.refresh(this.financialTransactionSearch);
        }
    }
}

