/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.entrybook;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.chorem.lima.entity.EntryBook;
import org.nuiton.i18n.I18n;

public class EntryBookTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7578692417919755647L;
    protected List<EntryBook> entryBooks;

    public EntryBookTableModel(List<EntryBook> entryBooks) {
        this.entryBooks = entryBooks;
    }

    @Override
    public int getRowCount() {
        int result = this.entryBooks.size();
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0: {
                res = I18n._((String)"lima.ui.entrybook.code", (Object[])new Object[0]);
                break;
            }
            case 1: {
                res = I18n._((String)"lima.ui.entrybook.label", (Object[])new Object[0]);
            }
        }
        return res;
    }

    public EntryBook getEntryBookAtRow(int row) {
        EntryBook entryBook = this.entryBooks.get(row);
        return entryBook;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String result = null;
        EntryBook entryBook = this.getEntryBookAtRow(row);
        switch (column) {
            case 0: {
                result = entryBook.getCode();
                break;
            }
            case 1: {
                result = entryBook.getLabel();
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void addEntryBook(EntryBook entryBook) {
        this.entryBooks.add(entryBook);
        int row = this.entryBooks.indexOf(entryBook);
        this.fireTableRowsInserted(row, row);
    }

    public void updateEntryBook(EntryBook entryBook) {
        int row = this.entryBooks.indexOf(entryBook);
        this.fireTableRowsUpdated(row, row);
    }

    public void removeEntryBook(EntryBook entryBook) {
        int row = this.entryBooks.indexOf(entryBook);
        this.entryBooks.remove(entryBook);
        this.fireTableRowsDeleted(row, row);
    }
}

