/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import org.apache.commons.lang3.time.DateUtils;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.jdesktop.swingx.JXDatePicker;

public class DateTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusListener,
AncestorListener {
    private static final long serialVersionUID = 1L;
    private final JXDatePicker datePicker = new JXDatePicker(LimaContext.getContext().getConfig().getLocale());
    private Date date;

    public DateTableCellEditor() {
        this.datePicker.getEditor().addFocusListener(this);
        this.datePicker.getEditor().addAncestorListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Date) {
            this.datePicker.setDate((Date)value);
            this.date = (Date)value;
        }
        return this.datePicker;
    }

    @Override
    public Object getCellEditorValue() {
        if (!this.datePicker.getEditor().getText().isEmpty()) {
            String[] str = this.datePicker.getEditor().getText().split("/");
            if (str.length > 0) {
                if (str[0].contains(" ")) {
                    String[] string = str[0].split(" ");
                    this.date = DateUtils.setDays((Date)this.date, (int)Integer.valueOf(string[1]));
                } else {
                    this.date = DateUtils.setDays((Date)this.date, (int)Integer.valueOf(str[0]));
                }
            }
            if (str.length > 1) {
                this.date = DateUtils.setMonths((Date)this.date, (int)(Integer.valueOf(str[1]) - 1));
            }
            if (str.length > 2) {
                this.date = DateUtils.setYears((Date)this.date, (int)Integer.valueOf(str[2]));
            }
        }
        this.datePicker.setDate(this.date);
        return this.datePicker.getDate();
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return !(evt instanceof MouseEvent) || ((MouseEvent)evt).getClickCount() == 2;
    }

    @Override
    public void focusGained(FocusEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFormattedTextField dateFormattedTextField = DateTableCellEditor.this.datePicker.getEditor();
                String comportmentEditingCell = LimaConfig.getInstance().getComportmentEditingCell();
                if (comportmentEditingCell.equals("ALL")) {
                    dateFormattedTextField.selectAll();
                } else {
                    int textFieldSize = dateFormattedTextField.getText().length();
                    dateFormattedTextField.select(textFieldSize, textFieldSize);
                }
            }
        });
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void ancestorAdded(AncestorEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DateTableCellEditor.this.datePicker.requestFocus();
            }
        });
    }

    @Override
    public void ancestorRemoved(AncestorEvent e) {
    }

    @Override
    public void ancestorMoved(AncestorEvent e) {
    }
}

