/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.account;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.Account;
import org.chorem.lima.enums.AccountsChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.account.AccountForm;
import org.chorem.lima.ui.account.AccountImportForm;
import org.chorem.lima.ui.account.AccountTreeTableModel;
import org.chorem.lima.ui.account.AccountView;
import org.chorem.lima.ui.account.UpdateAccountForm;
import org.chorem.lima.ui.importexport.ImportExport;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.nuiton.i18n.I18n;

public class AccountViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(AccountViewHandler.class);
    protected AccountService accountService;
    protected AccountView view;
    protected static Comparator<Account> accountLengthComparator = new Comparator<Account>(){

        @Override
        public int compare(Account o1, Account o2) {
            int result = o1.getAccountNumber().length() - o2.getAccountNumber().length();
            if (result == 0) {
                result = o1.getAccountNumber().compareTo(o2.getAccountNumber());
            }
            return result;
        }
    };
    protected static Comparator<String> reverseAccountLengthComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int result = o2.length() - o1.length();
            if (result == 0) {
                result = o2.compareTo(o1);
            }
            return result;
        }
    };

    public AccountViewHandler(AccountView view) {
        this.view = view;
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);
    }

    public void init() {
        JXTreeTable table = this.view.getAccountsTreeTable();
        table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                JXTreeTable source = (JXTreeTable)e.getSource();
                if (e.getKeyCode() == 27 && !source.isEditing()) {
                    source.clearSelection();
                }
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JXTreeTable source = (JXTreeTable)e.getSource();
                if (source.rowAtPoint(e.getPoint()) == -1) {
                    source.clearSelection();
                }
            }
        });
        this.loadAllAccounts();
    }

    protected void loadAllAccounts() {
        List accounts = this.accountService.getAllAccounts();
        Collections.sort(accounts, accountLengthComparator);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded %d accounts from service", accounts.size()));
        }
        TreeMap<String, DefaultMutableTreeTableNode> nodeCache = new TreeMap<String, DefaultMutableTreeTableNode>(reverseAccountLengthComparator);
        DefaultMutableTreeTableNode root = new DefaultMutableTreeTableNode(null);
        for (Account account : accounts) {
            DefaultMutableTreeTableNode parentNode = root;
            for (Map.Entry entry : nodeCache.entrySet()) {
                String accountNumber = (String)entry.getKey();
                if (!account.getAccountNumber().startsWith(accountNumber)) continue;
                parentNode = (DefaultMutableTreeTableNode)entry.getValue();
                break;
            }
            DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)account);
            parentNode.add((MutableTreeTableNode)node);
            nodeCache.put(account.getAccountNumber(), node);
        }
        AccountTreeTableModel model = new AccountTreeTableModel((TreeTableNode)root);
        model.setColumnIdentifiers(Arrays.asList(I18n._((String)"lima.table.number", (Object[])new Object[0]), I18n._((String)"lima.table.label", (Object[])new Object[0])));
        JXTreeTable table = this.view.getAccountsTreeTable();
        table.setTreeTableModel((TreeTableModel)model);
    }

    public void addAccount() {
        AccountForm accountForm = new AccountForm((JAXXContext)this.view);
        accountForm.setLocationRelativeTo((Component)((Object)this.view));
        accountForm.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccount(AccountForm dialog) {
        try {
            Account newAccount = dialog.getAccount();
            newAccount = this.accountService.createAccount(newAccount);
            JXTreeTable treeTable = this.view.getAccountsTreeTable();
            DefaultTreeTableModel model = (DefaultTreeTableModel)treeTable.getTreeTableModel();
            DefaultMutableTreeTableNode node = (DefaultMutableTreeTableNode)this.findParentNode(model.getRoot(), newAccount.getAccountNumber());
            DefaultMutableTreeTableNode newNode = new DefaultMutableTreeTableNode((Object)newAccount);
            List<MutableTreeTableNode> nodesToMove = this.findSubNodes((TreeTableNode)node, newAccount.getAccountNumber());
            for (MutableTreeTableNode nodeToMove : nodesToMove) {
                model.removeNodeFromParent(nodeToMove);
                newNode.add(nodeToMove);
            }
            model.insertNodeInto((MutableTreeTableNode)newNode, (MutableTreeTableNode)node, node.getChildCount());
            treeTable.expandPath(new TreePath(model.getPathToRoot((TreeTableNode)node)));
        }
        finally {
            dialog.dispose();
        }
    }

    protected TreeTableNode findParentNode(TreeTableNode currentNode, String accountNumber) {
        TreeTableNode result = null;
        Account account = (Account)currentNode.getUserObject();
        if (account == null || accountNumber.startsWith(account.getAccountNumber())) {
            for (int childIndex = 0; childIndex < currentNode.getChildCount() && result == null; ++childIndex) {
                TreeTableNode child = currentNode.getChildAt(childIndex);
                result = this.findParentNode(child, accountNumber);
            }
            if (result == null) {
                result = currentNode;
            }
        }
        return result;
    }

    protected List<MutableTreeTableNode> findSubNodes(TreeTableNode currentNode, String accountNumber) {
        ArrayList<MutableTreeTableNode> nodes = new ArrayList<MutableTreeTableNode>();
        for (int childIndex = 0; childIndex < currentNode.getChildCount(); ++childIndex) {
            MutableTreeTableNode child = (MutableTreeTableNode)currentNode.getChildAt(childIndex);
            Account account = (Account)child.getUserObject();
            if (!account.getAccountNumber().startsWith(accountNumber)) continue;
            nodes.add(child);
        }
        return nodes;
    }

    public void updateAccount() {
        JXTreeTable treeTable = this.view.getAccountsTreeTable();
        int selectedRow = treeTable.getSelectedRow();
        TreePath treePath = treeTable.getPathForRow(selectedRow);
        TreeTableNode lastPathComponent = (TreeTableNode)treePath.getLastPathComponent();
        Account selectedAccount = (Account)lastPathComponent.getUserObject();
        UpdateAccountForm accountForm = new UpdateAccountForm((JAXXContext)this.view);
        accountForm.setAccount(selectedAccount);
        accountForm.setLocationRelativeTo((Component)((Object)this.view));
        accountForm.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccount(UpdateAccountForm dialog) {
        try {
            Account account = dialog.getAccount();
            account = this.accountService.updateAccount(account);
            JXTreeTable treeTable = this.view.getAccountsTreeTable();
            DefaultTreeTableModel model = (DefaultTreeTableModel)treeTable.getTreeTableModel();
            int selectedRow = treeTable.getSelectedRow();
            TreePath treePath = treeTable.getPathForRow(selectedRow);
            model.valueForPathChanged(treePath, (Object)account);
        }
        finally {
            dialog.dispose();
        }
    }

    public void removeAccount() {
        JXTreeTable treeTable = this.view.getAccountsTreeTable();
        int selectedRow = treeTable.getSelectedRow();
        TreePath treePath = treeTable.getPathForRow(selectedRow);
        MutableTreeTableNode lastNode = (MutableTreeTableNode)treePath.getLastPathComponent();
        Account account = (Account)lastNode.getUserObject();
        int response = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.ui.account.removeaccountconfirm", (Object[])new Object[]{account.getAccountNumber()}), I18n._((String)"lima.ui.account.removeaccounttitle", (Object[])new Object[0]), 0, 3);
        if (response == 0) {
            this.accountService.removeAccount(account);
            DefaultTreeTableModel model = (DefaultTreeTableModel)treeTable.getTreeTableModel();
            MutableTreeTableNode parent = (MutableTreeTableNode)lastNode.getParent();
            for (int childIndex = lastNode.getChildCount() - 1; childIndex >= 0; --childIndex) {
                MutableTreeTableNode child = (MutableTreeTableNode)lastNode.getChildAt(childIndex);
                model.insertNodeInto(child, parent, parent.getChildCount());
            }
            model.removeNodeFromParent(lastNode);
        }
    }

    public void importAccountsChart() {
        AccountImportForm form = new AccountImportForm((JAXXContext)this.view);
        form.setLocationRelativeTo((Component)((Object)this.view));
        form.setVisible(true);
        ImportExport importExport = new ImportExport((Component)((Object)this.view));
        Object value = form.getButtonGroup().getSelectedValue();
        if (value != null) {
            AccountsChartEnum defaultAccountsChartEnum = (AccountsChartEnum)((Object)value);
            switch (defaultAccountsChartEnum) {
                case IMPORTEBP: {
                    importExport.importExport(ImportExportEnum.EBP_ACCOUNTCHARTS_IMPORT, defaultAccountsChartEnum.getFilePath(), false);
                    break;
                }
                default: {
                    importExport.importExport(ImportExportEnum.CSV_ACCOUNTCHARTS_IMPORT, defaultAccountsChartEnum.getFilePath(), false);
                }
            }
        }
    }

    public void notifyMethod(String serviceName, String methodName) {
        if (methodName.contains("importAccounts") || methodName.contains("importAll") || methodName.contains("importAsCSV")) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Service notification %s, reloading accounts", methodName));
            }
            this.loadAllAccounts();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring service notification " + serviceName + ":" + methodName));
        }
    }
}

